/*
 * Decompiled with CFR 0.152.
 */
package ratpack.server.internal;

import com.google.common.base.Throwables;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.socket.SocketChannel;
import io.netty.util.ResourceLeakDetector;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ratpack.file.BaseDirRequiredException;
import ratpack.func.Function;
import ratpack.launch.LaunchConfig;
import ratpack.launch.LaunchException;
import ratpack.server.RatpackServer;
import ratpack.server.Stopper;
import ratpack.server.internal.HostUtil;
import ratpack.util.ExceptionUtils;
import ratpack.util.internal.ChannelImplDetector;

public class NettyRatpackServer
implements RatpackServer {
    private final Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());
    private final LaunchConfig launchConfig;
    private final Function<Stopper, ChannelInitializer<SocketChannel>> channelInitializerTransformer;
    private InetSocketAddress boundAddress;
    private Channel channel;
    private final Lock lifecycleLock = new ReentrantLock();
    private final AtomicBoolean running = new AtomicBoolean();

    public NettyRatpackServer(LaunchConfig launchConfig, Function<Stopper, ChannelInitializer<SocketChannel>> channelInitializerTransformer) {
        this.launchConfig = launchConfig;
        this.channelInitializerTransformer = channelInitializerTransformer;
    }

    @Override
    public LaunchConfig getLaunchConfig() {
        return this.launchConfig;
    }

    @Override
    public void start() throws LaunchException {
        this.lifecycleLock.lock();
        try {
            if (this.isRunning()) {
                return;
            }
            Stopper stopper = () -> {
                try {
                    this.stop();
                }
                catch (Exception e) {
                    throw ExceptionUtils.uncheck(e);
                }
            };
            ServerBootstrap bootstrap = new ServerBootstrap();
            ChannelInitializer<SocketChannel> channelInitializer = this.channelInitializerTransformer.apply(stopper);
            ((ServerBootstrap)bootstrap.group(this.launchConfig.getExecController().getEventLoopGroup()).childHandler(channelInitializer).channel(ChannelImplDetector.getServerSocketChannelImpl())).childOption(ChannelOption.ALLOCATOR, (Object)this.launchConfig.getBufferAllocator());
            if (System.getProperty("io.netty.leakDetectionLevel", null) == null) {
                ResourceLeakDetector.setLevel((ResourceLeakDetector.Level)ResourceLeakDetector.Level.DISABLED);
            }
            this.channel = bootstrap.bind((SocketAddress)this.buildSocketAddress()).sync().channel();
            this.boundAddress = (InetSocketAddress)this.channel.localAddress();
            if (this.logger.isInfoEnabled()) {
                this.logger.info(String.format("Ratpack started for %s://%s:%s", this.getScheme(), this.getBindHost(), this.getBindPort()));
            }
            this.running.set(true);
        }
        catch (Exception e) {
            Throwables.propagateIfInstanceOf((Throwable)e, BaseDirRequiredException.class);
            Throwables.propagateIfInstanceOf((Throwable)e, LaunchException.class);
            throw new LaunchException("Unable to launch due to exception", e);
        }
        finally {
            this.lifecycleLock.unlock();
        }
    }

    @Override
    public void stop() throws Exception {
        this.lifecycleLock.lock();
        try {
            if (!this.isRunning()) {
                return;
            }
            this.channel.close();
            this.partialShutdown();
            this.running.set(false);
        }
        finally {
            this.lifecycleLock.unlock();
        }
    }

    @Override
    public boolean isRunning() {
        return this.running.get();
    }

    private void partialShutdown() throws Exception {
        this.launchConfig.getExecController().close();
    }

    @Override
    public String getScheme() {
        return this.launchConfig.getSSLContext() == null ? "http" : "https";
    }

    @Override
    public int getBindPort() {
        return this.boundAddress == null ? -1 : this.boundAddress.getPort();
    }

    @Override
    public String getBindHost() {
        if (this.boundAddress == null) {
            return null;
        }
        return HostUtil.determineHost(this.boundAddress);
    }

    private InetSocketAddress buildSocketAddress() {
        return this.launchConfig.getAddress() == null ? new InetSocketAddress(this.launchConfig.getPort()) : new InetSocketAddress(this.launchConfig.getAddress(), this.launchConfig.getPort());
    }
}

