/*
 * Decompiled with CFR 0.152.
 */
package ratpack.sse;

import io.netty.buffer.ByteBufAllocator;
import org.reactivestreams.Publisher;
import ratpack.func.Action;
import ratpack.func.Function;
import ratpack.handling.Context;
import ratpack.http.Response;
import ratpack.http.internal.HttpHeaderConstants;
import ratpack.render.Renderable;
import ratpack.sse.internal.ServerSentEventEncoder;
import ratpack.stream.Streams;

public class ServerSentEvents
implements Renderable {
    private final Publisher<? extends Event<?>> publisher;

    public static <T> ServerSentEvents serverSentEvents(Publisher<T> publisher, Action<? super Event<T>> action) {
        return new ServerSentEvents(Streams.map(publisher, item -> {
            EventImpl<Object> event = action.with(new EventImpl<Object>(item));
            if (((EventImpl)event).id == null && ((EventImpl)event).event == null && ((EventImpl)event).data == null) {
                throw new IllegalArgumentException("You must supply at least one of data, event, id");
            }
            return event;
        }));
    }

    private ServerSentEvents(Publisher<? extends Event<?>> publisher) {
        this.publisher = publisher;
    }

    public Publisher<? extends Event<?>> getPublisher() {
        return this.publisher;
    }

    @Override
    public void render(Context context) throws Exception {
        ByteBufAllocator bufferAllocator = context.getLaunchConfig().getBufferAllocator();
        Response response = context.getResponse();
        response.getHeaders().add(HttpHeaderConstants.CONTENT_TYPE, HttpHeaderConstants.TEXT_EVENT_STREAM_CHARSET_UTF_8);
        response.getHeaders().add(HttpHeaderConstants.CACHE_CONTROL, HttpHeaderConstants.NO_CACHE_FULL);
        response.getHeaders().add(HttpHeaderConstants.PRAGMA, HttpHeaderConstants.NO_CACHE);
        response.sendStream(Streams.map(this.publisher, i -> ServerSentEventEncoder.INSTANCE.encode((Event<?>)i, bufferAllocator)));
    }

    private static class EventImpl<T>
    implements Event<T> {
        private final T item;
        private String id;
        private String event;
        private String data;

        public EventImpl(T item) {
            this.item = item;
        }

        @Override
        public T getItem() {
            return this.item;
        }

        @Override
        public Event<T> id(Function<? super T, String> id) throws Exception {
            this.id(id.apply(this.item));
            return this;
        }

        @Override
        public Event<T> id(String id) {
            this.id = id;
            return this;
        }

        @Override
        public Event<T> event(Function<? super T, String> id) throws Exception {
            this.event(id.apply(this.item));
            return this;
        }

        @Override
        public Event<T> event(String event) {
            this.event = event;
            return this;
        }

        @Override
        public Event<T> data(Function<? super T, String> id) throws Exception {
            this.data(id.apply(this.item));
            return this;
        }

        @Override
        public Event<T> data(String data) {
            this.data = data;
            return this;
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public String getEvent() {
            return this.event;
        }

        @Override
        public String getData() {
            return this.data;
        }
    }

    public static interface Event<T> {
        public T getItem();

        public String getId();

        public String getEvent();

        public String getData();

        public Event<T> id(Function<? super T, String> var1) throws Exception;

        public Event<T> id(String var1);

        public Event<T> event(Function<? super T, String> var1) throws Exception;

        public Event<T> event(String var1);

        public Event<T> data(Function<? super T, String> var1) throws Exception;

        public Event<T> data(String var1);
    }
}

