/*
 * Decompiled with CFR 0.152.
 */
package ratpack.stream.internal;

import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

abstract class SubscriptionSupport<T>
implements Subscription {
    private final Subscriber<? super T> subscriber;
    private final AtomicBoolean started = new AtomicBoolean();
    private final AtomicBoolean stopped = new AtomicBoolean();
    private final AtomicLong waitingRequests = new AtomicLong();
    private final AtomicBoolean drainingRequests = new AtomicBoolean();
    private final AtomicBoolean complete = new AtomicBoolean();
    private final AtomicReference<Throwable> error = new AtomicReference();
    private final AtomicBoolean inOnMethod = new AtomicBoolean();
    private final ConcurrentLinkedQueue<T> onNextQueue = new ConcurrentLinkedQueue();

    protected SubscriptionSupport(Subscriber<? super T> subscriber) {
        this.subscriber = subscriber;
        subscriber.onSubscribe((Subscription)this);
    }

    public final void request(long n) {
        if (n < 1L) {
            throw new IllegalArgumentException("3.9 While the Subscription is not cancelled, Subscription.request(long n) MUST throw a java.lang.IllegalArgumentException if the argument is <= 0.");
        }
        if (!this.stopped.get()) {
            this.waitingRequests.addAndGet(n);
            if (this.started.get()) {
                this.drainRequests();
            }
        }
    }

    protected boolean isStopped() {
        return this.stopped.get();
    }

    private void drainRequests() {
        if (this.drainingRequests.compareAndSet(false, true)) {
            try {
                long n = this.waitingRequests.getAndSet(0L);
                while (n > 0L) {
                    this.doRequest(n);
                    n = this.waitingRequests.getAndSet(0L);
                }
            }
            finally {
                this.drainingRequests.set(false);
            }
            if (this.waitingRequests.get() > 0L) {
                this.drainRequests();
            }
        }
    }

    protected abstract void doRequest(long var1);

    public final void cancel() {
        this.stopped.set(true);
        this.doCancel();
    }

    protected void doCancel() {
    }

    protected void start() {
        if (this.started.compareAndSet(false, true)) {
            this.drainRequests();
        }
    }

    private void nextEvent() {
        if (this.inOnMethod.compareAndSet(false, true)) {
            try {
                T next = this.onNextQueue.poll();
                while (next != null) {
                    this.subscriber.onNext(next);
                    next = this.onNextQueue.poll();
                }
                if (this.complete.get()) {
                    this.subscriber.onComplete();
                    return;
                }
                Throwable error = this.error.get();
                if (error != null) {
                    this.subscriber.onError(error);
                    return;
                }
            }
            finally {
                this.inOnMethod.set(false);
            }
            if (!this.onNextQueue.isEmpty() || this.complete.get() || this.error.get() != null) {
                this.nextEvent();
            }
        }
    }

    public void onNext(T t) {
        if (!this.stopped.get()) {
            this.onNextQueue.add(t);
            this.nextEvent();
        }
    }

    public void onError(Throwable t) {
        if (this.stopped.compareAndSet(false, true)) {
            this.error.set(t);
            this.nextEvent();
        }
    }

    public void onComplete() {
        if (this.stopped.compareAndSet(false, true)) {
            this.complete.set(true);
            this.nextEvent();
        }
    }
}

