/*
 * Decompiled with CFR 0.152.
 */
package ratpack.exec.internal;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Supplier;
import ratpack.exec.Fulfiller;
import ratpack.exec.Promise;
import ratpack.exec.Result;
import ratpack.exec.SuccessPromise;
import ratpack.exec.Throttle;
import ratpack.exec.internal.DefaultSuccessPromise;
import ratpack.exec.internal.ExecutionBacking;
import ratpack.func.Action;
import ratpack.func.Function;
import ratpack.func.NoArgAction;
import ratpack.func.Predicate;

public class CachingPromise<T>
implements Promise<T> {
    private final Consumer<? super Fulfiller<? super T>> fulfillment;
    private final Supplier<ExecutionBacking> executionSupplier;
    private final Action<? super Throwable> errorHandler;
    private final AtomicBoolean fired = new AtomicBoolean();
    private final Queue<Job> waiting = new ConcurrentLinkedQueue<Job>();
    private final AtomicBoolean draining = new AtomicBoolean();
    private final AtomicReference<Result<T>> result = new AtomicReference();

    public CachingPromise(Consumer<? super Fulfiller<? super T>> fulfillment, Supplier<ExecutionBacking> executionSupplier, Action<? super Throwable> errorHandler) {
        this.fulfillment = fulfillment;
        this.executionSupplier = executionSupplier;
        this.errorHandler = errorHandler;
    }

    @Override
    public SuccessPromise<T> onError(Action<? super Throwable> errorHandler) {
        return new DefaultSuccessPromise(this.executionSupplier, new Fulfillment(), errorHandler);
    }

    @Override
    public void then(Action<? super T> then) {
        this.newPromise().then(then);
    }

    private DefaultSuccessPromise<T> newPromise() {
        return new DefaultSuccessPromise(this.executionSupplier, new Fulfillment(), this.errorHandler);
    }

    @Override
    public <O> Promise<O> map(Function<? super T, ? extends O> transformer) {
        return this.newPromise().map(transformer);
    }

    @Override
    public <O> Promise<O> blockingMap(Function<? super T, ? extends O> transformer) {
        return this.newPromise().blockingMap(transformer);
    }

    @Override
    public <O> Promise<O> flatMap(Function<? super T, ? extends Promise<O>> transformer) {
        return this.newPromise().flatMap(transformer);
    }

    @Override
    public Promise<T> route(Predicate<? super T> predicate, Action<? super T> action) {
        return this.newPromise().route(predicate, action);
    }

    @Override
    public Promise<T> onNull(NoArgAction action) {
        return this.newPromise().onNull(action);
    }

    @Override
    public Promise<T> defer(Action<? super Runnable> releaser) {
        return this.newPromise().defer(releaser);
    }

    @Override
    public Promise<T> onYield(Runnable onYield) {
        return this.newPromise().onYield(onYield);
    }

    @Override
    public Promise<T> wiretap(Action<? super Result<T>> listener) {
        return this.newPromise().wiretap(listener);
    }

    @Override
    public Promise<T> throttled(Throttle throttle) {
        return this.newPromise().throttled(throttle);
    }

    @Override
    public Promise<T> cache() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryDrain() {
        if (this.draining.compareAndSet(false, true)) {
            try {
                Result result = this.result.get();
                Job job = this.waiting.poll();
                while (job != null) {
                    Job finalJob = job;
                    job.streamHandle.complete(() -> job.fulfiller.accept(result));
                    job = this.waiting.poll();
                }
            }
            finally {
                this.draining.set(false);
            }
        }
        if (!this.draining.get() && !this.waiting.isEmpty()) {
            this.tryDrain();
        }
    }

    private class Fulfillment
    implements Consumer<Fulfiller<? super T>> {
        private Fulfillment() {
        }

        @Override
        public void accept(final Fulfiller<? super T> fulfiller) {
            if (CachingPromise.this.fired.compareAndSet(false, true)) {
                CachingPromise.this.fulfillment.accept(new Fulfiller<T>(){

                    @Override
                    public void error(Throwable throwable) {
                        CachingPromise.this.result.set(Result.failure(throwable));
                        fulfiller.error(throwable);
                        ((ExecutionBacking)CachingPromise.this.executionSupplier.get()).getEventLoop().execute(() -> CachingPromise.this.tryDrain());
                    }

                    @Override
                    public void success(T value) {
                        CachingPromise.this.result.set(Result.success(value));
                        fulfiller.success(value);
                        ((ExecutionBacking)CachingPromise.this.executionSupplier.get()).getEventLoop().execute(() -> CachingPromise.this.tryDrain());
                    }
                });
            } else {
                ((ExecutionBacking)CachingPromise.this.executionSupplier.get()).streamSubscribe(streamHandle -> {
                    CachingPromise.this.waiting.add(new Job(fulfiller, (ExecutionBacking.StreamHandle)streamHandle));
                    if (CachingPromise.this.result.get() != null) {
                        CachingPromise.this.tryDrain();
                    }
                });
            }
        }
    }

    private class Job {
        final Fulfiller<? super T> fulfiller;
        final ExecutionBacking.StreamHandle streamHandle;

        private Job(Fulfiller<? super T> fulfiller, ExecutionBacking.StreamHandle streamHandle) {
            this.fulfiller = fulfiller;
            this.streamHandle = streamHandle;
        }
    }
}

