/*
 * Decompiled with CFR 0.152.
 */
package ratpack.handling;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ratpack.handling.Context;
import ratpack.handling.Handler;
import ratpack.handling.Handlers;
import ratpack.handling.internal.UuidBasedRequestIdGenerator;
import ratpack.http.Request;

public interface RequestId {
    public String getId();

    public static Handler bind() {
        return ctx -> {
            Generator generator = ctx.maybeGet(Generator.class).orElse(UuidBasedRequestIdGenerator.INSTANCE);
            RequestId requestId = generator.generate(ctx);
            ctx.getRequest().add(RequestId.class, (Object)requestId);
            ctx.next();
        };
    }

    public static Handler bindAndLog() {
        return Handlers.chain(RequestId.bind(), new Handler(){
            private final Logger logger = LoggerFactory.getLogger(RequestId.class);

            @Override
            public void handle(Context ctx) throws Exception {
                ctx.onClose(outcome -> {
                    Request request = ctx.getRequest();
                    StringBuilder logLine = new StringBuilder().append(request.getMethod().toString()).append(" ").append(request.getUri()).append(" ").append(outcome.getResponse().getStatus().getCode());
                    request.maybeGet(RequestId.class).ifPresent(id1 -> {
                        logLine.append(" id=");
                        logLine.append(id1.toString());
                    });
                    this.logger.info(logLine.toString());
                });
            }
        });
    }

    public static interface Generator {
        public RequestId generate(Context var1);
    }
}

