/*
 * Decompiled with CFR 0.152.
 */
package ratpack.handling.internal;

import java.net.URI;
import java.util.regex.Pattern;
import ratpack.handling.Context;
import ratpack.handling.Redirector;
import ratpack.http.Request;
import ratpack.http.internal.HttpHeaderConstants;
import ratpack.server.PublicAddress;

public class DefaultRedirector
implements Redirector {
    private static final Pattern ABSOLUTE_PATTERN = Pattern.compile("^https?://.*");

    @Override
    public void redirect(Context context, String location, int code) {
        context.getResponse().status(code);
        String normalizedLocation = this.generateRedirectLocation(context, context.getRequest(), location);
        context.getResponse().getHeaders().set(HttpHeaderConstants.LOCATION, normalizedLocation);
        context.getResponse().send();
    }

    private String generateRedirectLocation(Context context, Request request, String path) {
        PublicAddress publicAddress = context.get(PublicAddress.class);
        URI host = publicAddress.getAddress(context);
        String generatedPath = ABSOLUTE_PATTERN.matcher(path).matches() ? path : (path.charAt(0) == '/' ? host.toString() + path : host.toString() + this.getParentPath(request.getUri()) + path);
        return generatedPath;
    }

    private String getParentPath(String path) {
        String parentPath = "/";
        int indexOfSlash = path.lastIndexOf(47);
        if (indexOfSlash >= 0) {
            parentPath = path.substring(0, indexOfSlash) + '/';
        }
        if (!parentPath.startsWith("/")) {
            parentPath = "/" + parentPath;
        }
        return parentPath;
    }
}

