/*
 * Decompiled with CFR 0.152.
 */
package ratpack.logging.internal;

import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import ratpack.handling.RequestOutcome;
import ratpack.http.Request;
import ratpack.logging.RequestLogFormatter;

public class DefaultRequestLogFormatter
implements RequestLogFormatter {
    @Override
    public String format(RequestOutcome outcome) {
        RequestData data = new RequestData(outcome);
        return String.format("%s %s %s %s %s %s %s", data.getRemoteIp(), data.getUserIdentifier(), data.getUserId(), data.getDate(), data.getRequest(), data.getStatus(), data.getSize());
    }

    private class RequestData {
        private final RequestOutcome outcome;

        public RequestData(RequestOutcome outcome) {
            this.outcome = outcome;
        }

        String getRemoteIp() {
            return this.outcome.getRequest().getRemoteAddress().getHostText();
        }

        String getUserIdentifier() {
            return this.normalize(null);
        }

        String getUserId() {
            return null;
        }

        String getDate() {
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("%d/%b/%Y:%H:%M:%S %z");
            return this.normalize("[", "]", formatter.format(ZonedDateTime.ofInstant(Instant.ofEpochMilli(this.outcome.getClosedAt()), ZoneId.systemDefault())));
        }

        String getRequest() {
            Request request = this.outcome.getRequest();
            return String.format("\"%s %s %s\"", request.getMethod().getName(), request.getPath(), request.getHeaders().get("version"));
        }

        String getStatus() {
            return this.normalize(String.valueOf(this.outcome.getResponse().getStatus().getCode()));
        }

        String getSize() {
            return this.normalize(null);
        }

        private String normalize(String value) {
            return this.normalize("", "", value);
        }

        private String normalize(String prefix, String suffix, String value) {
            if (value == null) {
                return "-";
            }
            return String.format("%s%s%s", prefix, value, suffix);
        }
    }
}

