/*
 * Decompiled with CFR 0.152.
 */
package ratpack.path.internal;

import com.google.common.base.Predicate;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.reflect.TypeToken;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import ratpack.func.Action;
import ratpack.handling.Context;
import ratpack.handling.Handler;
import ratpack.path.PathBinder;
import ratpack.path.PathBinding;
import ratpack.registry.Registry;
import ratpack.util.Types;

public class PathHandler
implements Handler {
    private static final TypeToken<PathBinding> TYPE = TypeToken.of(PathBinding.class);
    private static final LoadingCache<CacheKey, Optional<Registry>> CACHE = CacheBuilder.newBuilder().maximumSize(2048L).build((CacheLoader)new CacheLoader<CacheKey, Optional<Registry>>(){

        public Optional<Registry> load(CacheKey key) throws Exception {
            Optional<PathBinding> binding = key.pathBinder.bind(key.path, key.parentBinding);
            if (binding.isPresent()) {
                return Optional.of(new PathBindingRegistry(binding));
            }
            return Optional.empty();
        }
    });
    private final PathBinder binder;
    private final Handler handler;

    public PathHandler(PathBinder binder, Handler handler) {
        this.binder = binder;
        this.handler = handler;
    }

    @Override
    public void handle(Context context) throws ExecutionException {
        Optional registry = (Optional)CACHE.get((Object)new CacheKey(this.binder, context.getRequest().getPath(), context.maybeGet(PathBinding.class)));
        if (registry.isPresent()) {
            context.insert((Registry)registry.get(), this.handler);
        } else {
            context.next();
        }
    }

    private static class PathBindingRegistry
    implements Registry {
        private final Optional<PathBinding> pathBindingOptional;

        public PathBindingRegistry(Optional<PathBinding> pathBindingOptional) {
            this.pathBindingOptional = pathBindingOptional;
        }

        private <O> Set<? extends O> asSet() {
            return (Set)Types.cast(Collections.singleton(this.pathBindingOptional.orElse(null)));
        }

        @Override
        public <O> Optional<O> maybeGet(Class<O> type) {
            return PathBinding.class.isAssignableFrom(type) ? (Optional)Types.cast(this.pathBindingOptional) : Optional.empty();
        }

        @Override
        public <O> Optional<O> maybeGet(TypeToken<O> type) {
            return TYPE.isAssignableFrom(type) ? (Optional)Types.cast(this.pathBindingOptional) : Optional.empty();
        }

        public <O> Set<? extends O> getAll(TypeToken<O> type) {
            return TYPE.isAssignableFrom(type) ? this.asSet() : Collections.emptySet();
        }

        public <O> Set<? extends O> getAll(Class<O> type) {
            return PathBinding.class.isAssignableFrom(type) ? this.asSet() : Collections.emptySet();
        }

        @Override
        public <T> Optional<T> first(TypeToken<T> type, Predicate<? super T> predicate) {
            return (Optional)Types.cast(this.pathBindingOptional.filter(p -> TYPE.isAssignableFrom(type) && predicate.apply(Types.cast(p))));
        }

        @Override
        public <T> Iterable<? extends T> all(TypeToken<T> type, Predicate<? super T> predicate) {
            return this.first(type, predicate).map(Collections::singleton).orElseGet(Collections::emptySet);
        }

        @Override
        public <T> boolean each(TypeToken<T> type, Predicate<? super T> predicate, Action<? super T> action) throws Exception {
            Optional<T> first = this.first(type, predicate);
            if (first.isPresent()) {
                action.execute(first.get());
                return true;
            }
            return false;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PathBindingRegistry that = (PathBindingRegistry)o;
            return this.pathBindingOptional.equals(that.pathBindingOptional);
        }

        public int hashCode() {
            return this.pathBindingOptional.hashCode();
        }
    }

    private static class CacheKey {
        private final PathBinder pathBinder;
        private final String path;
        private final Optional<PathBinding> parentBinding;

        public CacheKey(PathBinder pathBinder, String path, Optional<PathBinding> parentBinding) {
            this.pathBinder = pathBinder;
            this.path = path;
            this.parentBinding = parentBinding;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            return this.parentBinding.equals(cacheKey.parentBinding) && this.path.equals(cacheKey.path) && this.pathBinder.equals(cacheKey.pathBinder);
        }

        public int hashCode() {
            int result = this.pathBinder.hashCode();
            result = 31 * result + this.path.hashCode();
            result = 31 * result + this.parentBinding.hashCode();
            return result;
        }
    }
}

