/*
 * Decompiled with CFR 0.152.
 */
package ratpack.registry.internal;

import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;
import com.google.common.reflect.TypeToken;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import ratpack.func.Action;
import ratpack.registry.PredicateCacheability;
import ratpack.registry.Registry;
import ratpack.registry.RegistryBacking;
import ratpack.util.Types;

public class CachingBackedRegistry
implements Registry {
    private final RegistryBacking registryBacking;
    private final ConcurrentMap<TypeToken<?>, Iterable<? extends Supplier<?>>> supplierCache = new ConcurrentHashMap();
    private final ConcurrentMap<PredicateCacheability.CacheKey<?>, Iterable<? extends Supplier<?>>> predicateCache = new ConcurrentHashMap();

    public CachingBackedRegistry(RegistryBacking registryBacking) {
        this.registryBacking = registryBacking;
    }

    public <T> Optional<T> maybeGet(TypeToken<T> type) {
        Iterator<Supplier<T>> suppliers = this.getSuppliers(type).iterator();
        if (!suppliers.hasNext()) {
            return Optional.empty();
        }
        return Optional.of(suppliers.next().get());
    }

    private static <K, V> V compute(Map<K, V> map, K key, Function<? super K, ? extends V> supplier) {
        V value = map.get(key);
        if (value == null) {
            value = supplier.apply(key);
            map.put(key, value);
        }
        return value;
    }

    @Override
    public <O> Iterable<? extends O> getAll(TypeToken<O> type) {
        return this.transformToInstances(this.getSuppliers(type));
    }

    protected <O> Iterable<O> transformToInstances(Iterable<? extends Supplier<O>> suppliers) {
        return Iterables.transform(suppliers, s -> s.get());
    }

    protected <T> Iterable<? extends Supplier<T>> getSuppliers(TypeToken<T> type) {
        return (Iterable)Types.cast(CachingBackedRegistry.compute(this.supplierCache, type, t -> this.registryBacking.provide(type)));
    }

    protected <T> Iterable<? extends Supplier<T>> getSuppliers(TypeToken<T> type, final Predicate<? super T> predicate) {
        return (Iterable)Types.cast(CachingBackedRegistry.compute(this.predicateCache, new PredicateCacheability.CacheKey<T>(type, predicate), key -> Iterables.filter(this.getSuppliers(type), (Predicate)new Predicate<Supplier<T>>(){

            public boolean apply(Supplier<T> input) {
                return predicate.apply(input.get());
            }
        })));
    }

    @Override
    public <T> Optional<T> first(TypeToken<T> type, Predicate<? super T> predicate) {
        Iterator<T> matching = this.all(type, predicate).iterator();
        if (!matching.hasNext()) {
            return Optional.empty();
        }
        return Optional.of(matching.next());
    }

    @Override
    public <T> Iterable<? extends T> all(TypeToken<T> type, Predicate<? super T> predicate) {
        if (PredicateCacheability.isCacheable(predicate)) {
            return this.transformToInstances(this.getSuppliers(type, predicate));
        }
        return Iterables.filter(this.getAll(type), predicate);
    }

    @Override
    public <T> boolean each(TypeToken<T> type, Predicate<? super T> predicate, Action<? super T> action) throws Exception {
        if (PredicateCacheability.isCacheable(predicate)) {
            Iterable<T> all = this.all(type, predicate);
            boolean any = false;
            for (T t : all) {
                any = true;
                action.execute(t);
            }
            return any;
        }
        boolean foundMatch = false;
        Iterable<Supplier<T>> suppliers = this.getSuppliers(type);
        for (Supplier<T> supplier : suppliers) {
            Object instance = supplier.get();
            if (!predicate.apply(instance)) continue;
            action.execute(instance);
            foundMatch = true;
        }
        return foundMatch;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CachingBackedRegistry that = (CachingBackedRegistry)o;
        return this.registryBacking.equals(that.registryBacking);
    }

    public int hashCode() {
        return this.registryBacking.hashCode();
    }
}

