/*
 * Decompiled with CFR 0.152.
 */
package ratpack.render.internal;

import com.google.common.base.Predicate;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.reflect.TypeToken;
import ratpack.handling.Context;
import ratpack.render.NoSuchRendererException;
import ratpack.render.RenderableDecorator;
import ratpack.render.Renderer;
import ratpack.render.RendererException;
import ratpack.render.internal.RenderController;
import ratpack.util.Types;

public class DefaultRenderController
implements RenderController {
    private static final TypeToken<RenderableDecorator<?>> DECORATOR_TYPE = new TypeToken<RenderableDecorator<?>>(){};
    private static final TypeToken<Renderer<?>> RENDERER_TYPE = new TypeToken<Renderer<?>>(){};
    private final LoadingCache<Class<?>, RendererPredicate> rendererPredicateCache = CacheBuilder.newBuilder().build(new CacheLoader<Class<?>, RendererPredicate>(){

        public RendererPredicate load(Class<?> key) throws Exception {
            return new RendererPredicate(key);
        }
    });
    private final LoadingCache<Class<?>, DecoratorPredicate> decoratorPredicateCache = CacheBuilder.newBuilder().build(new CacheLoader<Class<?>, DecoratorPredicate>(){

        public DecoratorPredicate load(Class<?> key) throws Exception {
            return new DecoratorPredicate(key);
        }
    });

    @Override
    public void render(Object toRender, Context context) throws Exception {
        if (toRender == null) {
            context.clientError(404);
            return;
        }
        this.doRender(toRender, context);
    }

    private <T> void doRender(T toRender, Context context) throws Exception {
        Object cast;
        Class type = (Class)Types.cast(toRender.getClass());
        Iterable<RenderableDecorator<?>> decorators = context.all(DECORATOR_TYPE, (Predicate)this.decoratorPredicateCache.get((Object)type));
        for (RenderableDecorator<?> decorator : decorators) {
            cast = (RenderableDecorator)Types.cast(decorator);
            toRender = cast.decorate(context, toRender);
        }
        Object decorated = toRender;
        Renderer<?> renderer = context.first(RENDERER_TYPE, (Predicate)this.rendererPredicateCache.get((Object)type)).orElseThrow(() -> new NoSuchRendererException(decorated));
        cast = (Renderer)Types.cast(renderer);
        try {
            cast.render(context, decorated);
        }
        catch (Exception e) {
            throw new RendererException(renderer, decorated, e);
        }
    }

    private static class RendererPredicate
    implements Predicate<Renderer<?>> {
        private final Class<?> type;

        public RendererPredicate(Class<?> type) {
            this.type = type;
        }

        public boolean apply(Renderer<?> renderer) {
            return renderer.getType().isAssignableFrom(this.type);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RendererPredicate that = (RendererPredicate)o;
            return this.type.equals(that.type);
        }

        public int hashCode() {
            return this.type.hashCode();
        }
    }

    private static class DecoratorPredicate
    implements Predicate<RenderableDecorator<?>> {
        private final Class<?> type;

        public DecoratorPredicate(Class<?> type) {
            this.type = type;
        }

        public boolean apply(RenderableDecorator<?> t) {
            return t.getType().equals(this.type);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DecoratorPredicate that = (DecoratorPredicate)o;
            return this.type.equals(that.type);
        }

        public int hashCode() {
            return this.type.hashCode();
        }
    }
}

