/*
 * Decompiled with CFR 0.152.
 */
package ratpack.server;

import ratpack.func.Action;
import ratpack.func.Function;
import ratpack.handling.Chain;
import ratpack.handling.Handler;
import ratpack.handling.Handlers;
import ratpack.registry.Registry;
import ratpack.registry.RegistrySpec;
import ratpack.server.ServerConfig;
import ratpack.server.internal.NettyRatpackServer;

public interface RatpackServer {
    public static RatpackServer of(Function<? super Definition.Builder, ? extends Definition> definition) throws Exception {
        return new NettyRatpackServer(definition);
    }

    public static void start(Function<? super Definition.Builder, ? extends Definition> serverDefinition) throws Exception {
        RatpackServer.of(serverDefinition).start();
    }

    public String getScheme();

    public int getBindPort();

    public String getBindHost();

    public boolean isRunning();

    public void start() throws Exception;

    public void stop() throws Exception;

    public RatpackServer reload() throws Exception;

    public static interface Definition {
        public ServerConfig getServerConfig();

        public Function<? super Registry, ? extends Registry> getUserRegistryFactory();

        public Function<? super Registry, ? extends Handler> getHandlerFactory();

        public static interface Builder {
            public Builder registryOf(Action<? super RegistrySpec> var1) throws Exception;

            public Builder registry(Registry var1);

            public Builder registry(Function<? super Registry, ? extends Registry> var1);

            public Builder serverConfig(ServerConfig var1);

            default public Builder serverConfig(ServerConfig.Builder serverConfigBuilder) {
                return this.serverConfig(serverConfigBuilder.build());
            }

            default public Definition handler(Class<? extends Handler> handlerType) {
                return this.handler((? super Registry registry) -> (Handler)registry.get(handlerType));
            }

            public Definition handler(Function<? super Registry, ? extends Handler> var1);

            default public Definition handlers(Action<? super Chain> handlers) {
                return this.handler((? super Registry r) -> Handlers.chain(r, handlers));
            }
        }
    }
}

