/*
 * Decompiled with CFR 0.152.
 */
package ratpack.server.internal;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.net.InetAddress;
import java.net.URI;
import java.util.List;
import javax.net.ssl.SSLContext;
import ratpack.file.FileSystemBinding;
import ratpack.server.NoBaseDirException;
import ratpack.server.ServerConfig;

public class DefaultServerConfig
implements ServerConfig {
    private final FileSystemBinding baseDir;
    private final int port;
    private final InetAddress address;
    private final boolean development;
    private final int threads;
    private final URI publicAddress;
    private final ImmutableList<String> indexFiles;
    private final SSLContext sslContext;
    private final int maxContentLength;
    private final boolean timeResponses;
    private final boolean compressResponses;
    private final long compressionMinSize;
    private final ImmutableSet<String> compressionMimeTypeWhiteList;
    private final ImmutableSet<String> compressionMimeTypeBlackList;

    public DefaultServerConfig(FileSystemBinding baseDir, int port, InetAddress address, boolean development, int threads, URI publicAddress, ImmutableList<String> indexFiles, SSLContext sslContext, int maxContentLength, boolean timeResponses, boolean compressResponses, long compressionMinSize, ImmutableSet<String> compressionMimeTypeWhiteList, ImmutableSet<String> compressionMimeTypeBlackList) {
        this.baseDir = baseDir;
        this.port = port;
        this.address = address;
        this.development = development;
        this.threads = threads;
        this.timeResponses = timeResponses;
        this.compressResponses = compressResponses;
        this.compressionMinSize = compressionMinSize;
        this.compressionMimeTypeWhiteList = compressionMimeTypeWhiteList;
        this.compressionMimeTypeBlackList = compressionMimeTypeBlackList;
        this.publicAddress = publicAddress;
        this.indexFiles = indexFiles;
        this.sslContext = sslContext;
        this.maxContentLength = maxContentLength;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public InetAddress getAddress() {
        return this.address;
    }

    @Override
    public boolean isDevelopment() {
        return this.development;
    }

    @Override
    public int getThreads() {
        return this.threads;
    }

    @Override
    public URI getPublicAddress() {
        return this.publicAddress;
    }

    @Override
    public List<String> getIndexFiles() {
        return this.indexFiles;
    }

    @Override
    public SSLContext getSSLContext() {
        return this.sslContext;
    }

    @Override
    public int getMaxContentLength() {
        return this.maxContentLength;
    }

    @Override
    public boolean isTimeResponses() {
        return this.timeResponses;
    }

    @Override
    public boolean isCompressResponses() {
        return this.compressResponses;
    }

    @Override
    public long getCompressionMinSize() {
        return this.compressionMinSize;
    }

    @Override
    public ImmutableSet<String> getCompressionMimeTypeWhiteList() {
        return this.compressionMimeTypeWhiteList;
    }

    @Override
    public ImmutableSet<String> getCompressionMimeTypeBlackList() {
        return this.compressionMimeTypeBlackList;
    }

    @Override
    public boolean isHasBaseDir() {
        return this.baseDir != null;
    }

    @Override
    public FileSystemBinding getBaseDir() throws NoBaseDirException {
        if (this.baseDir == null) {
            throw new NoBaseDirException("No base dir has been set");
        }
        return this.baseDir;
    }
}

