/*
 * Decompiled with CFR 0.152.
 */
package ratpack.server.internal;

import com.google.common.base.CaseFormat;
import com.google.common.base.StandardSystemProperty;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.io.ByteSource;
import com.google.common.io.Resources;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.net.ssl.SSLContext;
import ratpack.file.FileSystemBinding;
import ratpack.file.internal.DefaultFileSystemBinding;
import ratpack.func.Action;
import ratpack.func.Predicate;
import ratpack.server.ServerConfig;
import ratpack.server.ServerEnvironment;
import ratpack.server.internal.BaseDirFinder;
import ratpack.server.internal.DefaultServerConfig;
import ratpack.ssl.SSLContexts;
import ratpack.util.ExceptionUtils;
import ratpack.util.internal.Paths2;

public class DefaultServerConfigBuilder
implements ServerConfig.Builder {
    private ServerEnvironment serverEnvironment;
    private FileSystemBinding baseDir;
    private int port;
    private InetAddress address;
    private boolean development;
    private int threads = ServerConfig.DEFAULT_THREADS;
    private URI publicAddress;
    private ImmutableList.Builder<String> indexFiles = ImmutableList.builder();
    private SSLContext sslContext;
    private int maxContentLength = 0x100000;
    private boolean timeResponses;
    private boolean compressResponses;
    private long compressionMinSize = 1024L;
    private final ImmutableSet.Builder<String> compressionMimeTypeWhiteList = ImmutableSet.builder();
    private final ImmutableSet.Builder<String> compressionMimeTypeBlackList = ImmutableSet.builder();
    private InputStream sslKeystore;
    private String sslKeystorePassword = "";

    private DefaultServerConfigBuilder(ServerEnvironment serverEnvironment, Optional<Path> baseDir) {
        if (baseDir.isPresent()) {
            this.baseDir = new DefaultFileSystemBinding(baseDir.get());
        }
        this.serverEnvironment = serverEnvironment;
        this.port = serverEnvironment.getPort();
        this.development = serverEnvironment.isDevelopment();
        this.publicAddress = serverEnvironment.getPublicAddress();
    }

    public static ServerConfig.Builder noBaseDir(ServerEnvironment serverEnvironment) {
        return new DefaultServerConfigBuilder(serverEnvironment, Optional.empty());
    }

    public static ServerConfig.Builder baseDir(ServerEnvironment serverEnvironment, Path baseDir) {
        return new DefaultServerConfigBuilder(serverEnvironment, Optional.of(baseDir.toAbsolutePath().normalize()));
    }

    public static ServerConfig.Builder findBaseDirProps(ServerEnvironment serverEnvironment, String propertiesPath) {
        String workingDir = StandardSystemProperty.USER_DIR.value();
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        BaseDirFinder.Result result = BaseDirFinder.find(workingDir, classLoader, propertiesPath).orElseThrow(() -> new IllegalStateException("Could not find properties file '" + propertiesPath + "' in working dir '" + workingDir + "' or context class loader classpath"));
        return DefaultServerConfigBuilder.baseDir(serverEnvironment, result.getBaseDir()).props(result.getResource());
    }

    @Override
    public ServerConfig.Builder port(int port) {
        this.port = port;
        return this;
    }

    @Override
    public ServerConfig.Builder address(InetAddress address) {
        this.address = address;
        return this;
    }

    @Override
    public ServerConfig.Builder development(boolean development) {
        this.development = development;
        return this;
    }

    @Override
    public ServerConfig.Builder threads(int threads) {
        if (threads < 1) {
            throw new IllegalArgumentException("'threads' must be > 0");
        }
        this.threads = threads;
        return this;
    }

    @Override
    public ServerConfig.Builder publicAddress(URI publicAddress) {
        this.publicAddress = publicAddress;
        return this;
    }

    @Override
    public ServerConfig.Builder maxContentLength(int maxContentLength) {
        this.maxContentLength = maxContentLength;
        return this;
    }

    @Override
    public ServerConfig.Builder timeResponses(boolean timeResponses) {
        this.timeResponses = timeResponses;
        return this;
    }

    @Override
    public ServerConfig.Builder compressResponses(boolean compressResponses) {
        this.compressResponses = compressResponses;
        return this;
    }

    @Override
    public ServerConfig.Builder compressionMinSize(long compressionMinSize) {
        this.compressionMinSize = compressionMinSize;
        return this;
    }

    @Override
    public ServerConfig.Builder compressionWhiteListMimeTypes(String ... mimeTypes) {
        this.compressionMimeTypeWhiteList.add((Object[])mimeTypes);
        return this;
    }

    @Override
    public ServerConfig.Builder compressionWhiteListMimeTypes(List<String> mimeTypes) {
        this.compressionMimeTypeWhiteList.addAll(mimeTypes);
        return this;
    }

    @Override
    public ServerConfig.Builder compressionBlackListMimeTypes(String ... mimeTypes) {
        this.compressionMimeTypeBlackList.add((Object[])mimeTypes);
        return this;
    }

    @Override
    public ServerConfig.Builder compressionBlackListMimeTypes(List<String> mimeTypes) {
        this.compressionMimeTypeBlackList.addAll(mimeTypes);
        return this;
    }

    @Override
    public ServerConfig.Builder indexFiles(String ... indexFiles) {
        this.indexFiles.add((Object[])indexFiles);
        return this;
    }

    @Override
    public ServerConfig.Builder indexFiles(List<String> indexFiles) {
        this.indexFiles.addAll(indexFiles);
        return this;
    }

    @Override
    public ServerConfig.Builder ssl(SSLContext sslContext) {
        this.sslContext = sslContext;
        return this;
    }

    @Override
    public ServerConfig build() {
        this.loadSSLIfConfigured();
        return new DefaultServerConfig(this.baseDir, this.port, this.address, this.development, this.threads, this.publicAddress, (ImmutableList<String>)this.indexFiles.build(), this.sslContext, this.maxContentLength, this.timeResponses, this.compressResponses, this.compressionMinSize, (ImmutableSet<String>)this.compressionMimeTypeWhiteList.build(), (ImmutableSet<String>)this.compressionMimeTypeBlackList.build());
    }

    @Override
    public ServerConfig.Builder env() {
        return this.env("RATPACK_");
    }

    @Override
    public ServerConfig.Builder env(String prefix) {
        Map<String, String> filteredEnvVars = this.serverEnvironment.getenv().entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith(prefix)).collect(Collectors.toMap(entry -> CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, ((String)entry.getKey()).replace(prefix, "")), Map.Entry::getValue));
        return this.props(filteredEnvVars);
    }

    @Override
    public ServerConfig.Builder props(ByteSource byteSource) {
        Properties properties = new Properties();
        try (InputStream is = byteSource.openStream();){
            properties.load(is);
        }
        catch (IOException e) {
            throw ExceptionUtils.uncheck(e);
        }
        return this.props(properties);
    }

    @Override
    public ServerConfig.Builder props(String path) {
        return this.props(Paths.get(path, new String[0]));
    }

    @Override
    public ServerConfig.Builder props(Path path) {
        return this.props(Paths2.asByteSource(path));
    }

    @Override
    public ServerConfig.Builder props(Map<String, String> map) {
        Map<String, BuilderAction<?>> propertyCoercions = this.createPropertyCoercions();
        map.entrySet().forEach(entry -> {
            BuilderAction mapping = (BuilderAction)propertyCoercions.get(entry.getKey());
            if (mapping != null) {
                try {
                    mapping.apply((String)entry.getValue());
                }
                catch (Exception e) {
                    throw ExceptionUtils.uncheck(e);
                }
            }
        });
        return this;
    }

    @Override
    public ServerConfig.Builder props(Properties properties) {
        HashMap map = Maps.newHashMapWithExpectedSize((int)properties.size());
        properties.entrySet().forEach(e -> map.put(e.getKey().toString(), e.getValue().toString()));
        return this.props(map);
    }

    @Override
    public ServerConfig.Builder props(URL url) {
        return this.props(Resources.asByteSource((URL)url));
    }

    @Override
    public ServerConfig.Builder sysProps() {
        return this.sysProps("ratpack.");
    }

    @Override
    public ServerConfig.Builder sysProps(String prefix) {
        Map<String, String> filteredProperties = DefaultServerConfigBuilder.filter(this.serverEnvironment.getProperties().entrySet(), entry -> entry.getKey().toString().startsWith(prefix)).collect(Collectors.toMap(p -> p.getKey().toString().replace(prefix, ""), p -> p.getValue().toString()));
        return this.props(filteredProperties);
    }

    private ServerConfig.Builder sslKeystore(InputStream is) {
        this.sslKeystore = is;
        return this;
    }

    private ServerConfig.Builder sslKeystorePassword(String password) {
        this.sslKeystorePassword = password;
        return this;
    }

    private void loadSSLIfConfigured() {
        if (this.sslKeystore != null) {
            try (InputStream stream = this.sslKeystore;){
                this.ssl(SSLContexts.sslContext(stream, this.sslKeystorePassword));
            }
            catch (IOException | GeneralSecurityException e) {
                throw ExceptionUtils.uncheck(e);
            }
        }
    }

    private static <E> Stream<E> filter(Collection<E> collection, Predicate<E> predicate) {
        return collection.stream().filter(predicate.toPredicate());
    }

    private static String[] split(String s) {
        return (String[])Arrays.stream(s.split(",")).map(String::trim).toArray(String[]::new);
    }

    private static InputStream asStream(String path) {
        try {
            InputStream stream;
            block7: {
                stream = null;
                if (path != null) {
                    File file = new File(path);
                    if (file.isFile()) {
                        stream = new FileInputStream(file);
                    } else {
                        try {
                            URL url = new URL(path);
                            stream = url.openStream();
                        }
                        catch (MalformedURLException e) {
                            stream = DefaultServerConfigBuilder.class.getClassLoader().getResourceAsStream(path);
                            if (stream != null) break block7;
                            throw new FileNotFoundException(path);
                        }
                    }
                }
            }
            return stream;
        }
        catch (IOException e) {
            throw ExceptionUtils.uncheck(e);
        }
    }

    private static InetAddress inetAddress(String s) {
        return ExceptionUtils.uncheck(() -> InetAddress.getByName(s));
    }

    private Map<String, BuilderAction<?>> createPropertyCoercions() {
        return ImmutableMap.builder().put((Object)"port", new BuilderAction<Integer>(Integer::parseInt, this::port)).put((Object)"address", new BuilderAction<InetAddress>(DefaultServerConfigBuilder::inetAddress, this::address)).put((Object)"development", new BuilderAction<Boolean>(Boolean::parseBoolean, this::development)).put((Object)"threads", new BuilderAction<Integer>(Integer::parseInt, this::threads)).put((Object)"publicAddress", new BuilderAction<URI>(URI::create, this::publicAddress)).put((Object)"maxContentLength", new BuilderAction<Integer>(Integer::parseInt, this::maxContentLength)).put((Object)"timeResponses", new BuilderAction<Boolean>(Boolean::parseBoolean, this::timeResponses)).put((Object)"compressResponses", new BuilderAction<Boolean>(Boolean::parseBoolean, this::compressResponses)).put((Object)"compressionMinSize", new BuilderAction<Long>(Long::parseLong, this::compressionMinSize)).put((Object)"compressionWhiteListMimeTypes", new BuilderAction<String[]>(DefaultServerConfigBuilder::split, this::compressionWhiteListMimeTypes)).put((Object)"compressionBlackListMimeTypes", new BuilderAction<String[]>(DefaultServerConfigBuilder::split, this::compressionBlackListMimeTypes)).put((Object)"indexFiles", new BuilderAction<String[]>(DefaultServerConfigBuilder::split, this::indexFiles)).put((Object)"sslKeystoreFile", new BuilderAction<InputStream>(DefaultServerConfigBuilder::asStream, this::sslKeystore)).put((Object)"sslKeystorePassword", new BuilderAction<String>(Function.identity(), this::sslKeystorePassword)).build();
    }

    private static class BuilderAction<T> {
        private final Function<String, T> converter;
        private final Action<T> action;

        public BuilderAction(Function<String, T> converter, Action<T> action) {
            this.converter = converter;
            this.action = action;
        }

        public void apply(String value) throws Exception {
            this.action.execute(this.converter.apply(value));
        }
    }
}

