/*
 * Decompiled with CFR 0.152.
 */
package ratpack.server.internal;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.UnpooledByteBufAllocator;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import ratpack.server.ReloadInformant;
import ratpack.util.ExceptionUtils;
import ratpack.util.internal.IoUtils;

public class FileBackedReloadInformant
implements ReloadInformant {
    private final Path file;
    private final Lock lock = new ReentrantLock();
    private final AtomicReference<FileTime> lastModifiedHolder = new AtomicReference<Object>(null);
    private final AtomicReference<ByteBuf> contentHolder = new AtomicReference();

    public FileBackedReloadInformant(Path file) {
        this.file = file;
        this.load();
    }

    private void load() {
        this.lock.lock();
        try {
            FileTime lastModifiedTime = Files.getLastModifiedTime(this.file, new LinkOption[0]);
            ByteBuf bytes = IoUtils.read((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT, this.file);
            this.lastModifiedHolder.set(lastModifiedTime);
            this.contentHolder.set(bytes);
        }
        catch (Exception e) {
            throw ExceptionUtils.uncheck(e);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean shouldReload() {
        int i = 10;
        while (!Files.exists(this.file, new LinkOption[0]) && --i > 0) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                throw ExceptionUtils.uncheck(e);
            }
        }
        if (!Files.exists(this.file, new LinkOption[0])) {
            return false;
        }
        try {
            return this.reloadNeeded();
        }
        catch (Exception e) {
            throw ExceptionUtils.uncheck(e);
        }
    }

    @Override
    public String toString() {
        return "file-backed reload informant: " + this.file.toString();
    }

    private boolean reloadNeeded() throws IOException {
        return !this.isBytesAreSame();
    }

    private boolean isBytesAreSame() throws IOException {
        this.lock.lock();
        try {
            ByteBuf existing = this.contentHolder.get();
            if (existing == null) {
                boolean bl = false;
                return bl;
            }
            boolean bl = IoUtils.read((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT, this.file).equals((Object)existing);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }
}

