/*
 * Decompiled with CFR 0.152.
 */
package ratpack.server.internal;

import com.google.common.reflect.TypeToken;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponseEncoder;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.stream.ChunkedWriteHandler;
import io.netty.util.ResourceLeakDetector;
import java.io.File;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ratpack.exec.ExecController;
import ratpack.exec.internal.DefaultExecController;
import ratpack.func.BiAction;
import ratpack.func.Function;
import ratpack.handling.Handler;
import ratpack.handling.HandlerDecorator;
import ratpack.handling.internal.FactoryHandler;
import ratpack.registry.Registries;
import ratpack.registry.Registry;
import ratpack.reload.internal.ClassUtil;
import ratpack.reload.internal.ReloadableFileBackedFactory;
import ratpack.server.RatpackServer;
import ratpack.server.ReloadInformant;
import ratpack.server.ServerConfig;
import ratpack.server.Service;
import ratpack.server.StartEvent;
import ratpack.server.StopEvent;
import ratpack.server.internal.DefaultRatpackServerDefinitionBuilder;
import ratpack.server.internal.DefaultServerDefinition;
import ratpack.server.internal.DelegatingServerConfig;
import ratpack.server.internal.HostUtil;
import ratpack.server.internal.NettyHandlerAdapter;
import ratpack.server.internal.ServerCapturer;
import ratpack.server.internal.ServerRegistry;
import ratpack.server.internal.SmartHttpContentCompressor;
import ratpack.util.ExceptionUtils;
import ratpack.util.internal.ChannelImplDetector;

public class NettyRatpackServer
implements RatpackServer {
    public static final TypeToken<HandlerDecorator> HANDLER_DECORATOR_TYPE_TOKEN;
    private static final Logger LOGGER;
    protected final Function<? super RatpackServer.Definition.Builder, ? extends RatpackServer.Definition> definitionFactory;
    protected InetSocketAddress boundAddress;
    protected Channel channel;
    protected ExecController execController;
    protected Registry serverRegistry = Registries.empty();
    protected boolean reloading;
    protected final AtomicBoolean needsReload = new AtomicBoolean();
    protected SSLEngine sslEngine;
    private final ServerCapturer.Overrides overrides;

    public NettyRatpackServer(Function<? super RatpackServer.Definition.Builder, ? extends RatpackServer.Definition> definitionFactory) throws Exception {
        this.definitionFactory = definitionFactory;
        this.overrides = ServerCapturer.capture(this);
    }

    @Override
    public synchronized void start() throws Exception {
        if (this.isRunning()) {
            return;
        }
        DefinitionBuild definitionBuild = this.buildUserDefinition();
        if (definitionBuild.error != null) {
            if (definitionBuild.getServerConfig().isDevelopment()) {
                LOGGER.warn("Exception raised getting server config (will use default config until reload):", definitionBuild.error);
                this.needsReload.set(true);
            } else {
                throw ExceptionUtils.toException(definitionBuild.error);
            }
        }
        ServerConfig serverConfig = definitionBuild.getServerConfig();
        this.execController = new DefaultExecController(serverConfig.getThreads());
        ChannelHandler channelHandler = this.buildHandler(definitionBuild);
        this.channel = this.buildChannel(serverConfig, channelHandler);
        this.boundAddress = (InetSocketAddress)this.channel.localAddress();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info(String.format("Ratpack started for %s://%s:%s", this.getScheme(), this.getBindHost(), this.getBindPort()));
        }
    }

    protected DefinitionBuild buildUserDefinition() throws Exception {
        try {
            return new DefinitionBuild(this.overrides, this.definitionFactory.apply(new DefaultRatpackServerDefinitionBuilder()), null);
        }
        catch (Exception e) {
            return new DefinitionBuild(this.overrides, new DefaultServerDefinition(ServerConfig.noBaseDir().build(), r -> Registries.empty(), r -> ctx -> ctx.error(e)), e);
        }
    }

    private ChannelHandler buildHandler(DefinitionBuild definitionBuild) throws Exception {
        if (definitionBuild.getServerConfig().isDevelopment()) {
            return new ReloadHandler(definitionBuild);
        }
        return this.buildAdapter(definitionBuild);
    }

    protected Channel buildChannel(final ServerConfig serverConfig, final ChannelHandler handlerAdapter) throws InterruptedException {
        final SSLContext sslContext = serverConfig.getSSLContext();
        if (sslContext != null) {
            this.sslEngine = sslContext.createSSLEngine();
            this.sslEngine.setUseClientMode(false);
        }
        return ((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().group(this.execController.getEventLoopGroup()).channel(ChannelImplDetector.getServerSocketChannelImpl())).option(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT)).childOption(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) throws Exception {
                ChannelPipeline pipeline = ch.pipeline();
                if (sslContext != null) {
                    pipeline.addLast("ssl", (ChannelHandler)new SslHandler(NettyRatpackServer.this.sslEngine));
                }
                pipeline.addLast("decoder", (ChannelHandler)new HttpRequestDecoder(4096, 8192, 8192, false));
                pipeline.addLast("aggregator", (ChannelHandler)new HttpObjectAggregator(serverConfig.getMaxContentLength()));
                pipeline.addLast("encoder", (ChannelHandler)new HttpResponseEncoder());
                if (serverConfig.isCompressResponses()) {
                    pipeline.addLast("deflater", (ChannelHandler)new SmartHttpContentCompressor());
                }
                pipeline.addLast("chunkedWriter", (ChannelHandler)new ChunkedWriteHandler());
                pipeline.addLast("adapter", handlerAdapter);
            }
        }).bind((SocketAddress)this.buildSocketAddress(serverConfig)).sync().channel();
    }

    protected NettyHandlerAdapter buildAdapter(DefinitionBuild definition) throws Exception {
        this.serverRegistry = this.buildServerRegistry(definition.getServerConfig(), definition.getUserRegistryFactory());
        Handler ratpackHandler = this.buildRatpackHandler(definition.getServerConfig(), this.serverRegistry, definition.getHandlerFactory());
        ratpackHandler = this.decorateHandler(ratpackHandler, this.serverRegistry);
        this.executeEvents(this.serverRegistry, StartEvent.build(this.serverRegistry, this.reloading), Service::onStart);
        return new NettyHandlerAdapter(definition.getServerConfig(), this.serverRegistry, ratpackHandler);
    }

    private Registry buildServerRegistry(ServerConfig serverConfig, Function<? super Registry, ? extends Registry> userRegistryFactory) {
        return ServerRegistry.serverRegistry(this, this.execController, serverConfig, userRegistryFactory);
    }

    private Handler decorateHandler(Handler rootHandler, Registry serverRegistry) {
        for (HandlerDecorator handlerDecorator : serverRegistry.getAll(HANDLER_DECORATOR_TYPE_TOKEN)) {
            rootHandler = handlerDecorator.decorate(serverRegistry, rootHandler);
        }
        return rootHandler;
    }

    private Handler buildRatpackHandler(ServerConfig serverConfig, Registry serverRegistry, Function<? super Registry, ? extends Handler> handlerFactory) throws Exception {
        File classFile;
        if (serverConfig.isDevelopment() && (classFile = ClassUtil.getClassFile(handlerFactory)) != null) {
            ReloadableFileBackedFactory<Handler> factory = new ReloadableFileBackedFactory<Handler>(classFile.toPath(), true, (file, bytes) -> (Handler)handlerFactory.apply(this.serverRegistry));
            return new FactoryHandler(factory);
        }
        return handlerFactory.apply(serverRegistry);
    }

    @Override
    public synchronized void stop() throws Exception {
        try {
            if (!this.isRunning()) {
                return;
            }
            if (this.serverRegistry != null) {
                this.executeEvents(this.serverRegistry, StopEvent.build(this.serverRegistry, this.reloading), Service::onStop);
            }
        }
        finally {
            Optional.ofNullable(this.channel).ifPresent(Channel::close);
            Optional.ofNullable(this.execController).ifPresent(ExecController::close);
            this.channel = null;
            this.execController = null;
        }
    }

    @Override
    public synchronized RatpackServer reload() throws Exception {
        this.reloading = true;
        boolean start = false;
        if (this.isRunning()) {
            start = true;
            this.stop();
        }
        if (start) {
            this.start();
        }
        this.reloading = false;
        return this;
    }

    @Override
    public synchronized boolean isRunning() {
        return this.channel != null;
    }

    @Override
    public synchronized String getScheme() {
        return this.isRunning() ? (this.sslEngine == null ? "http" : "https") : null;
    }

    @Override
    public synchronized int getBindPort() {
        return this.boundAddress == null ? -1 : this.boundAddress.getPort();
    }

    @Override
    public synchronized String getBindHost() {
        if (this.boundAddress == null) {
            return null;
        }
        return HostUtil.determineHost(this.boundAddress);
    }

    private InetSocketAddress buildSocketAddress(ServerConfig serverConfig) {
        return serverConfig.getAddress() == null ? new InetSocketAddress(serverConfig.getPort()) : new InetSocketAddress(serverConfig.getAddress(), serverConfig.getPort());
    }

    private <E> void executeEvents(Registry registry, E event, BiAction<Service, E> action) throws Exception {
        registry.getAll(Service.class).forEach(listener -> ExceptionUtils.uncheck(listener, event, action));
    }

    static {
        if (System.getProperty("io.netty.leakDetectionLevel", null) == null) {
            ResourceLeakDetector.setLevel((ResourceLeakDetector.Level)ResourceLeakDetector.Level.DISABLED);
        }
        HANDLER_DECORATOR_TYPE_TOKEN = TypeToken.of(HandlerDecorator.class);
        LOGGER = LoggerFactory.getLogger(RatpackServer.class);
    }

    @ChannelHandler.Sharable
    private class ReloadHandler
    extends SimpleChannelInboundHandler<FullHttpRequest> {
        private ServerConfig lastServerConfig;
        private DefinitionBuild definitionBuild;
        private final Lock reloadLock;
        private ChannelHandler inner;

        public ReloadHandler(DefinitionBuild definition) {
            super(false);
            this.reloadLock = new ReentrantLock();
            this.definitionBuild = definition;
            this.lastServerConfig = this.definitionBuild.getServerConfig();
            try {
                this.inner = NettyRatpackServer.this.buildAdapter(this.definitionBuild);
            }
            catch (Exception e) {
                this.inner = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void channelRead0(ChannelHandlerContext ctx, FullHttpRequest msg) throws Exception {
            this.reloadLock.lock();
            try {
                boolean rebuild = false;
                if (this.inner == null || this.definitionBuild.error != null) {
                    rebuild = true;
                } else {
                    Optional reloadInformant = NettyRatpackServer.this.serverRegistry.first(TypeToken.of(ReloadInformant.class), ReloadInformant::shouldReload);
                    if (reloadInformant.isPresent()) {
                        LOGGER.warn("reload requested by '" + reloadInformant.get() + "'");
                        rebuild = true;
                    }
                }
                if (rebuild) {
                    try {
                        this.definitionBuild = NettyRatpackServer.this.buildUserDefinition();
                        this.lastServerConfig = this.definitionBuild.getServerConfig();
                        this.inner = NettyRatpackServer.this.buildAdapter(this.definitionBuild);
                        this.delegate(ctx, this.inner, msg);
                    }
                    catch (Exception e) {
                        this.delegate(ctx, (ChannelHandler)this.buildErrorRenderingAdapter(e), msg);
                    }
                } else {
                    this.delegate(ctx, this.inner, msg);
                }
            }
            finally {
                this.reloadLock.unlock();
            }
        }

        private NettyHandlerAdapter buildErrorRenderingAdapter(Exception e) {
            try {
                return new NettyHandlerAdapter(this.lastServerConfig, NettyRatpackServer.this.buildServerRegistry(this.lastServerConfig, r -> Registries.empty()), context -> context.error(e));
            }
            catch (Exception e1) {
                throw ExceptionUtils.uncheck(e);
            }
        }

        private void delegate(ChannelHandlerContext ctx, ChannelHandler delegate, FullHttpRequest msg) {
            try {
                ctx.pipeline().remove("inner");
            }
            catch (Exception ignore) {
                // empty catch block
            }
            ctx.pipeline().addLast("inner", delegate);
            ctx.fireChannelRead((Object)msg);
        }
    }

    private static class DefinitionBuild
    implements RatpackServer.Definition {
        private final ServerCapturer.Overrides overrides;
        private final RatpackServer.Definition definition;
        private final Throwable error;
        private final ServerConfig serverConfig;
        private final Function<? super Registry, ? extends Registry> userRegistryFactory;

        public DefinitionBuild(final ServerCapturer.Overrides overrides, RatpackServer.Definition definition, Throwable error) {
            this.overrides = overrides;
            this.definition = definition;
            this.error = error;
            this.serverConfig = new DelegatingServerConfig(definition.getServerConfig()){

                @Override
                public int getPort() {
                    return overrides.getPort() < 0 ? super.getPort() : overrides.getPort();
                }

                @Override
                public boolean isDevelopment() {
                    return overrides.isDevelopment() == null ? super.isDevelopment() : overrides.isDevelopment().booleanValue();
                }
            };
            Registry serverConfigOverrideRegistry = Registries.just(ServerConfig.class, this.serverConfig);
            this.userRegistryFactory = baseRegistry -> {
                Registry actualBaseRegistry = baseRegistry.join(serverConfigOverrideRegistry);
                Registry userRegistry = definition.getUserRegistryFactory().apply(actualBaseRegistry);
                Registry overrideRegistry = overrides.getRegistryFunction().apply(userRegistry);
                return userRegistry.join(overrideRegistry);
            };
        }

        public ServerCapturer.Overrides getOverrides() {
            return this.overrides;
        }

        @Override
        public ServerConfig getServerConfig() {
            return this.serverConfig;
        }

        @Override
        public Function<? super Registry, ? extends Registry> getUserRegistryFactory() {
            return this.userRegistryFactory;
        }

        @Override
        public Function<? super Registry, ? extends Handler> getHandlerFactory() {
            return this.definition.getHandlerFactory();
        }
    }
}

