/*
 * Decompiled with CFR 0.152.
 */
package ratpack.stream;

import java.time.Duration;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import org.reactivestreams.Publisher;
import ratpack.exec.ExecControl;
import ratpack.exec.ExecController;
import ratpack.exec.Promise;
import ratpack.func.Action;
import ratpack.func.Function;
import ratpack.registry.Registry;
import ratpack.stream.StreamEvent;
import ratpack.stream.TransformablePublisher;
import ratpack.stream.WriteStream;
import ratpack.stream.YieldRequest;
import ratpack.stream.internal.BufferingPublisher;
import ratpack.stream.internal.CollectingSubscriber;
import ratpack.stream.internal.DefaultTransformablePublisher;
import ratpack.stream.internal.FanOutPublisher;
import ratpack.stream.internal.FlatMapPublisher;
import ratpack.stream.internal.GatedPublisher;
import ratpack.stream.internal.IterablePublisher;
import ratpack.stream.internal.MapPublisher;
import ratpack.stream.internal.MergingPublisher;
import ratpack.stream.internal.MulticastPublisher;
import ratpack.stream.internal.PeriodicPublisher;
import ratpack.stream.internal.SingleElementSubscriber;
import ratpack.stream.internal.StreamMapPublisher;
import ratpack.stream.internal.WiretapPublisher;
import ratpack.stream.internal.YieldingPublisher;
import ratpack.util.Types;

public class Streams {
    public static <T> TransformablePublisher<T> transformable(Publisher<T> publisher) {
        if (publisher instanceof TransformablePublisher) {
            return (TransformablePublisher)Types.cast(publisher);
        }
        return new DefaultTransformablePublisher<T>(publisher);
    }

    public static <T> TransformablePublisher<T> publish(Iterable<T> iterable) {
        return new IterablePublisher<T>(iterable);
    }

    public static <T> TransformablePublisher<T> yield(Function<? super YieldRequest, T> producer) {
        return new YieldingPublisher<T>(producer);
    }

    public static <T> TransformablePublisher<T> constant(T item) {
        return Streams.yield(yieldRequest -> item);
    }

    public static <I, O> TransformablePublisher<O> map(Publisher<I> input, Function<? super I, ? extends O> function) {
        return new MapPublisher<O, I>(input, function);
    }

    public static <I, O> TransformablePublisher<O> streamMap(Publisher<I> input, Function<? super WriteStream<O>, ? extends WriteStream<I>> mapper) {
        return new StreamMapPublisher(input, mapper).buffer();
    }

    public static <I, O> TransformablePublisher<O> flatMap(Publisher<I> input, Function<? super I, ? extends Promise<? extends O>> function) {
        return new FlatMapPublisher(input, function);
    }

    public static <T> TransformablePublisher<T> buffer(Publisher<T> publisher) {
        return new BufferingPublisher<T>(publisher);
    }

    public static <T> TransformablePublisher<T> gate(Publisher<T> publisher, Action<? super Runnable> valveReceiver) {
        return new GatedPublisher<T>(publisher, valveReceiver);
    }

    public static <T> TransformablePublisher<T> periodically(ScheduledExecutorService executorService, Duration duration, Function<Integer, T> producer) {
        return new PeriodicPublisher<T>(executorService, producer, duration).buffer();
    }

    public static <T> TransformablePublisher<T> periodically(Registry registry, Duration duration, Function<Integer, T> producer) {
        return new PeriodicPublisher<T>(registry.get(ExecController.class).getExecutor(), producer, duration).buffer();
    }

    public static <T> TransformablePublisher<T> wiretap(Publisher<T> publisher, Action<? super StreamEvent<? super T>> listener) {
        return new WiretapPublisher<T>(publisher, listener);
    }

    public static <T> TransformablePublisher<T> multicast(Publisher<T> publisher) {
        return new MulticastPublisher<T>(publisher);
    }

    public static <T> TransformablePublisher<T> fanOut(Publisher<? extends Iterable<T>> publisher) {
        return new FanOutPublisher(publisher).buffer();
    }

    @SafeVarargs
    public static <T> TransformablePublisher<T> merge(Publisher<? extends T> ... publishers) {
        return new MergingPublisher<T>(publishers).buffer();
    }

    public static <T> Promise<T> toPromise(Publisher<T> publisher) {
        return Streams.toPromise(ExecControl.current(), publisher);
    }

    public static <T> Promise<T> toPromise(ExecControl execControl, Publisher<T> publisher) {
        return execControl.promise(f -> publisher.subscribe(SingleElementSubscriber.to(f::accept)));
    }

    public static <T> Promise<List<T>> toList(Publisher<T> publisher) {
        return Streams.toList(ExecControl.current(), publisher);
    }

    public static <T> Promise<List<T>> toList(ExecControl execControl, Publisher<T> publisher) {
        return execControl.promise(f -> publisher.subscribe(new CollectingSubscriber(f::accept, s -> s.request(Long.MAX_VALUE))));
    }
}

