/*
 * Decompiled with CFR 0.152.
 */
package ratpack.util;

import ratpack.api.UncheckedException;
import ratpack.func.Action;
import ratpack.func.BiAction;
import ratpack.func.Factory;

public abstract class ExceptionUtils {
    public static RuntimeException uncheck(Throwable throwable) {
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        if (throwable instanceof RuntimeException) {
            return (RuntimeException)throwable;
        }
        return new UncheckedException(throwable);
    }

    public static Exception toException(Throwable throwable) {
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        if (throwable instanceof Exception) {
            return (Exception)throwable;
        }
        return new UncheckedException(throwable);
    }

    public static void throwIfError(Throwable throwable) {
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
    }

    public static <T> T uncheck(Factory<T> factory) {
        try {
            return factory.create();
        }
        catch (Exception e) {
            throw ExceptionUtils.uncheck(e);
        }
    }

    public static <T> void uncheck(T input, Action<T> action) {
        try {
            action.execute(input);
        }
        catch (Exception e) {
            throw ExceptionUtils.uncheck(e);
        }
    }

    public static <T, U> void uncheck(T input1, U input2, BiAction<T, U> action) {
        try {
            action.execute(input1, input2);
        }
        catch (Exception e) {
            throw ExceptionUtils.uncheck(e);
        }
    }
}

