/*
 * Decompiled with CFR 0.152.
 */
package ratpack.exec.internal;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ratpack.exec.ExecInterceptor;
import ratpack.exec.Execution;
import ratpack.util.ExceptionUtils;

public abstract class InterceptedOperation {
    private static final Logger LOGGER = LoggerFactory.getLogger(InterceptedOperation.class);
    private final Execution execution;
    private final ExecInterceptor.ExecType type;
    private final List<ExecInterceptor> interceptors;
    private Throwable thrown;
    private int i;

    public InterceptedOperation(Execution execution, ExecInterceptor.ExecType type, List<ExecInterceptor> interceptors) {
        this.execution = execution;
        this.type = type;
        this.interceptors = interceptors;
        this.i = 0;
    }

    public void run() throws Exception {
        if (this.interceptors.isEmpty()) {
            this.performOperation();
        } else {
            this.nextInterceptor();
            if (this.thrown != null) {
                throw ExceptionUtils.toException(this.thrown);
            }
        }
    }

    private void nextInterceptor() {
        block6: {
            if (this.i < this.interceptors.size()) {
                int iAtStart = this.i;
                ExecInterceptor interceptor = this.interceptors.get(this.i);
                Runnable continuation = () -> {
                    try {
                        ++this.i;
                        this.nextInterceptor();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                };
                try {
                    interceptor.intercept(this.execution, this.type, continuation);
                }
                catch (Throwable e) {
                    LOGGER.error("", e);
                    if (this.i == iAtStart) {
                        continuation.run();
                    }
                    break block6;
                }
            }
            try {
                this.performOperation();
            }
            catch (Throwable e) {
                this.thrown = e;
            }
        }
    }

    protected abstract void performOperation() throws Exception;
}

