/*
 * Decompiled with CFR 0.152.
 */
package ratpack.handling.internal;

import java.util.Map;
import ratpack.func.NoArgAction;
import ratpack.handling.ByContentSpec;
import ratpack.handling.Context;
import ratpack.handling.Handler;

public class DefaultByContentSpec
implements ByContentSpec {
    public static final String TYPE_PLAIN_TEXT = "text/plain";
    public static final String TYPE_HTML = "text/html";
    public static final String TYPE_JSON = "application/json";
    public static final String TYPE_XML = "application/xml";
    private final Map<String, Handler> map;
    private Handler noMatchHandler = ctx -> ctx.clientError(406);

    public DefaultByContentSpec(Map<String, Handler> map) {
        this.map = map;
    }

    @Override
    public ByContentSpec type(String mimeType, NoArgAction handler) {
        return this.type(mimeType, (Context ctx) -> handler.execute());
    }

    @Override
    public ByContentSpec type(String mimeType, Handler handler) {
        if (mimeType == null) {
            throw new IllegalArgumentException("mimeType cannot be null");
        }
        String trimmed = mimeType.trim();
        if (trimmed.isEmpty()) {
            throw new IllegalArgumentException("mimeType cannot be a blank string");
        }
        if (trimmed.contains("*")) {
            throw new IllegalArgumentException("mimeType cannot include wildcards");
        }
        this.map.put(trimmed, handler);
        return this;
    }

    @Override
    public ByContentSpec plainText(NoArgAction handler) {
        return this.type(TYPE_PLAIN_TEXT, handler);
    }

    @Override
    public ByContentSpec plainText(Handler handler) {
        return this.type(TYPE_PLAIN_TEXT, handler);
    }

    @Override
    public ByContentSpec html(NoArgAction handler) {
        return this.type(TYPE_HTML, handler);
    }

    @Override
    public ByContentSpec html(Handler handler) {
        return this.type(TYPE_HTML, handler);
    }

    @Override
    public ByContentSpec json(NoArgAction handler) {
        return this.type(TYPE_JSON, handler);
    }

    @Override
    public ByContentSpec json(Handler handler) {
        return this.type(TYPE_JSON, handler);
    }

    @Override
    public ByContentSpec xml(NoArgAction handler) {
        return this.type(TYPE_XML, handler);
    }

    @Override
    public ByContentSpec xml(Handler handler) {
        return this.type(TYPE_XML, handler);
    }

    @Override
    public ByContentSpec noMatch(NoArgAction handler) {
        this.noMatchHandler = ctx -> handler.execute();
        return this;
    }

    @Override
    public ByContentSpec noMatch(String mimeType) {
        return this.noMatch((Context ctx) -> {
            ctx.getResponse().contentType(mimeType);
            ctx.insert(this.map.get(mimeType));
        });
    }

    @Override
    public ByContentSpec noMatch(Handler handler) {
        this.noMatchHandler = handler;
        return this;
    }

    public Handler getNoMatchHandler() {
        return this.noMatchHandler;
    }
}

