/*
 * Decompiled with CFR 0.152.
 */
package ratpack.http.internal;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.Cookie;
import io.netty.handler.codec.http.DefaultCookie;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.ServerCookieEncoder;
import io.netty.util.CharsetUtil;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;
import ratpack.exec.ExecControl;
import ratpack.file.internal.DefaultFileRenderer;
import ratpack.file.internal.ResponseTransmitter;
import ratpack.func.Action;
import ratpack.handling.internal.DefaultContext;
import ratpack.http.Headers;
import ratpack.http.MutableHeaders;
import ratpack.http.Response;
import ratpack.http.ResponseMetaData;
import ratpack.http.Status;
import ratpack.http.internal.DefaultStatus;
import ratpack.http.internal.HttpHeaderConstants;
import ratpack.util.ExceptionUtils;
import ratpack.util.MultiValueMap;

public class DefaultResponse
implements Response {
    private HttpResponseStatus status = HttpResponseStatus.OK;
    private final MutableHeaders headers;
    private final ExecControl execControl;
    private final ByteBufAllocator byteBufAllocator;
    private final ResponseTransmitter responseTransmitter;
    private final DefaultContext.RequestConstants requestConstants;
    private boolean contentTypeSet;
    private Set<Cookie> cookies;
    private List<Action<? super ResponseMetaData>> responseFinalizers;

    public DefaultResponse(ExecControl execControl, MutableHeaders headers, ByteBufAllocator byteBufAllocator, ResponseTransmitter responseTransmitter, DefaultContext.RequestConstants requestConstants) {
        this.execControl = execControl;
        this.byteBufAllocator = byteBufAllocator;
        this.responseTransmitter = responseTransmitter;
        this.requestConstants = requestConstants;
        this.headers = new MutableHeadersWrapper(headers);
        this.responseFinalizers = Lists.newArrayList();
    }

    @Override
    public Status getStatus() {
        return new DefaultStatus(this.status);
    }

    @Override
    public Response status(int code) {
        this.status = HttpResponseStatus.valueOf((int)code);
        return this;
    }

    @Override
    public Response status(Status status) {
        return this.status(status.getCode());
    }

    @Override
    public MutableHeaders getHeaders() {
        return this.headers;
    }

    @Override
    public void send() {
        this.commit(this.byteBufAllocator.buffer(0, 0));
    }

    @Override
    public Response contentTypeIfNotSet(Supplier<CharSequence> contentType) {
        if (!this.contentTypeSet) {
            this.contentType(contentType.get());
        }
        return this;
    }

    @Override
    public Response contentType(CharSequence contentType) {
        this.headers.set(HttpHeaderConstants.CONTENT_TYPE, contentType);
        return this;
    }

    @Override
    public void send(String text) {
        ByteBuf byteBuf = ByteBufUtil.encodeString((ByteBufAllocator)this.byteBufAllocator, (CharBuffer)CharBuffer.wrap(text), (Charset)CharsetUtil.UTF_8);
        this.contentTypeIfNotSet(HttpHeaderConstants.PLAIN_TEXT_UTF8).send(byteBuf);
    }

    @Override
    public void send(CharSequence contentType, String body) {
        this.contentType(contentType);
        this.send(body);
    }

    @Override
    public void send(byte[] bytes) {
        this.contentTypeIfNotSet(HttpHeaderConstants.OCTET_STREAM);
        this.commit(Unpooled.wrappedBuffer((byte[])bytes));
    }

    @Override
    public void send(CharSequence contentType, byte[] bytes) {
        this.contentType(contentType).send(bytes);
    }

    @Override
    public void send(CharSequence contentType, ByteBuf buffer) {
        this.contentType(contentType);
        this.send(buffer);
    }

    @Override
    public void send(ByteBuf buffer) {
        this.contentTypeIfNotSet(HttpHeaderConstants.OCTET_STREAM);
        this.commit(buffer);
    }

    @Override
    public void sendFile(BasicFileAttributes attributes, Path file) {
        this.finalizeResponse();
        this.setCookieHeader();
        this.responseTransmitter.transmit(this.requestConstants.context, this.status, attributes, file);
    }

    @Override
    public void sendStream(Publisher<? extends ByteBuf> stream) {
        this.finalizeResponse();
        this.setCookieHeader();
        stream.subscribe(this.responseTransmitter.transmitter(this.requestConstants.context, this.status));
    }

    @Override
    public Response beforeSend(Action<? super ResponseMetaData> responseFinalizer) {
        this.responseFinalizers.add(responseFinalizer);
        return this;
    }

    @Override
    public void sendFile(Path file) {
        try {
            DefaultFileRenderer.readAttributes(this.execControl, file, fileAttributes -> this.sendFile((BasicFileAttributes)fileAttributes, file));
        }
        catch (Exception e) {
            throw ExceptionUtils.uncheck(e);
        }
    }

    @Override
    public Set<Cookie> getCookies() {
        if (this.cookies == null) {
            this.cookies = Sets.newHashSet();
        }
        return this.cookies;
    }

    @Override
    public Cookie cookie(String name, String value) {
        DefaultCookie cookie = new DefaultCookie(name, value);
        this.getCookies().add((Cookie)cookie);
        return cookie;
    }

    @Override
    public Cookie expireCookie(String name) {
        Cookie cookie = this.cookie(name, "");
        cookie.setMaxAge(0L);
        return cookie;
    }

    private void setCookieHeader() {
        if (this.cookies != null && !this.cookies.isEmpty()) {
            for (Cookie cookie : this.cookies) {
                this.headers.add(HttpHeaderConstants.SET_COOKIE, ServerCookieEncoder.encode((Cookie)cookie));
            }
        }
    }

    private void commit(ByteBuf byteBuf) {
        this.finalizeResponse();
        this.setCookieHeader();
        this.responseTransmitter.transmit(this.requestConstants.context, this.status, byteBuf);
    }

    private void finalizeResponse() {
        for (Action<? super ResponseMetaData> responseFinalizer : this.responseFinalizers) {
            try {
                responseFinalizer.execute(this);
            }
            catch (Exception e) {
                throw ExceptionUtils.uncheck(e);
            }
        }
    }

    class MutableHeadersWrapper
    implements MutableHeaders {
        private final MutableHeaders wrapped;

        MutableHeadersWrapper(MutableHeaders wrapped) {
            this.wrapped = wrapped;
        }

        @Override
        public MutableHeaders add(CharSequence name, Object value) {
            if (!DefaultResponse.this.contentTypeSet && (name == HttpHeaderConstants.CONTENT_TYPE || name.toString().equalsIgnoreCase(HttpHeaderConstants.CONTENT_TYPE.toString()))) {
                DefaultResponse.this.contentTypeSet = true;
            }
            this.wrapped.add(name, value);
            return this;
        }

        @Override
        public MutableHeaders set(CharSequence name, Object value) {
            if (!DefaultResponse.this.contentTypeSet && (name == HttpHeaderConstants.CONTENT_TYPE || name.toString().equalsIgnoreCase(HttpHeaderConstants.CONTENT_TYPE.toString()))) {
                DefaultResponse.this.contentTypeSet = true;
            }
            this.wrapped.set(name, value);
            return this;
        }

        @Override
        public MutableHeaders setDate(CharSequence name, Date value) {
            this.wrapped.set(name, value);
            return this;
        }

        @Override
        public MutableHeaders set(CharSequence name, Iterable<?> values) {
            if (!DefaultResponse.this.contentTypeSet && (name == HttpHeaderConstants.CONTENT_TYPE || name.toString().equalsIgnoreCase(HttpHeaderConstants.CONTENT_TYPE.toString()))) {
                DefaultResponse.this.contentTypeSet = true;
            }
            this.wrapped.set(name, values);
            return this;
        }

        @Override
        public MutableHeaders remove(CharSequence name) {
            if (name == HttpHeaderConstants.CONTENT_TYPE || name.toString().equalsIgnoreCase(HttpHeaderConstants.CONTENT_TYPE.toString())) {
                DefaultResponse.this.contentTypeSet = false;
            }
            this.wrapped.remove(name);
            return this;
        }

        @Override
        public MutableHeaders clear() {
            DefaultResponse.this.contentTypeSet = false;
            this.wrapped.clear();
            return this;
        }

        @Override
        public MutableHeaders copy(Headers headers) {
            this.wrapped.copy(headers);
            if (headers.contains(HttpHeaderConstants.CONTENT_TYPE)) {
                DefaultResponse.this.contentTypeSet = true;
            }
            return this;
        }

        @Override
        public MultiValueMap<String, String> asMultiValueMap() {
            return this.wrapped.asMultiValueMap();
        }

        @Override
        public String get(CharSequence name) {
            return this.wrapped.get(name);
        }

        @Override
        public String get(String name) {
            return this.wrapped.get(name);
        }

        @Override
        public Date getDate(CharSequence name) {
            return this.wrapped.getDate(name);
        }

        @Override
        public Date getDate(String name) {
            return this.wrapped.getDate(name);
        }

        @Override
        public List<String> getAll(CharSequence name) {
            return this.wrapped.getAll(name);
        }

        @Override
        public List<String> getAll(String name) {
            return this.wrapped.getAll(name);
        }

        @Override
        public boolean contains(CharSequence name) {
            return this.wrapped.contains(name);
        }

        @Override
        public boolean contains(String name) {
            return this.wrapped.contains(name);
        }

        @Override
        public Set<String> getNames() {
            return this.wrapped.getNames();
        }

        @Override
        public HttpHeaders getNettyHeaders() {
            return this.wrapped.getNettyHeaders();
        }
    }
}

