/*
 * Decompiled with CFR 0.152.
 */
package ratpack.logging;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.MDC;
import ratpack.exec.ExecInterceptor;
import ratpack.exec.Execution;
import ratpack.util.Types;

public class MDCInterceptor
implements ExecInterceptor {
    @Override
    public void intercept(Execution execution, ExecInterceptor.ExecType type, Runnable continuation) {
        MDCMap map = execution.maybeGet(MDCMap.class).orElse(null);
        if (map == null) {
            map = new MDCMap();
            execution.add(map);
        }
        MDC.setContextMap((Map)map);
        continuation.run();
        map.clear();
        Map ctxMap = (Map)Types.cast(MDC.getCopyOfContextMap());
        if (ctxMap != null && ctxMap.size() > 0) {
            map.putAll(ctxMap);
            MDC.clear();
        }
    }

    private static class MDCMap
    extends HashMap<String, String> {
        private MDCMap() {
        }
    }
}

