/*
 * Decompiled with CFR 0.152.
 */
package ratpack.path;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ratpack.path.PathBinder;
import ratpack.path.PathBinderBuilder;
import ratpack.path.internal.DefaultPathBinderBuilder;

public abstract class PathBinders {
    private static final Pattern PLACEHOLDER = Pattern.compile("((?:^|/):(\\w+)\\??:([^/])+)|((?:^|/)::([^/])+)|((?:^|/):(\\w+)\\??)");

    private PathBinders() {
    }

    public static PathBinder parse(String path, boolean exact) {
        DefaultPathBinderBuilder pathBinderBuilder = new DefaultPathBinderBuilder();
        Matcher matchResult = PLACEHOLDER.matcher(path);
        int lastIndex = 0;
        if (matchResult.find()) {
            do {
                int thisIndex;
                if ((thisIndex = matchResult.start()) != lastIndex) {
                    pathBinderBuilder.literal(path.substring(lastIndex, thisIndex));
                }
                lastIndex = matchResult.end();
                String component = matchResult.group(0);
                boolean found = false;
                for (TokenType type : TokenType.values()) {
                    if (!type.match(component, pathBinderBuilder)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                throw new IllegalArgumentException(String.format("Cannot match path %s (%s)", path, component));
            } while (matchResult.find());
            if (lastIndex < path.length()) {
                pathBinderBuilder.literal(path.substring(lastIndex));
            }
        } else {
            pathBinderBuilder.literal(path);
        }
        return pathBinderBuilder.build(exact);
    }

    public static PathBinderBuilder builder() {
        return new DefaultPathBinderBuilder();
    }

    private static interface TokenProcessor {
        public void process(Matcher var1, PathBinderBuilder var2);
    }

    private static enum TokenType implements TokenProcessor
    {
        OPTIONAL_TOKEN_WITH_PATTERN("/?:(\\w*)\\?:(.+)"){

            @Override
            public void process(Matcher matcher, PathBinderBuilder builder) {
                builder.optionalTokenWithPattern(matcher.group(1), matcher.group(2));
            }
        }
        ,
        LITERAL_WITH_PATTERN("/?::(.+)"){

            @Override
            public void process(Matcher matcher, PathBinderBuilder builder) {
                builder.literalPattern(matcher.group(1));
            }
        }
        ,
        TOKEN_WITH_PATTERN("/?:(\\w*):(.+)"){

            @Override
            public void process(Matcher matcher, PathBinderBuilder builder) {
                builder.tokenWithPattern(matcher.group(1), matcher.group(2));
            }
        }
        ,
        TOKEN("/?:(\\w*)"){

            @Override
            public void process(Matcher matcher, PathBinderBuilder builder) {
                builder.token(matcher.group(1));
            }
        }
        ,
        OPTIONAL_TOKEN("/?:(\\w*)\\?"){

            @Override
            public void process(Matcher matcher, PathBinderBuilder builder) {
                builder.optionalToken(matcher.group(1));
            }
        };

        private Pattern pattern;

        boolean match(String component, PathBinderBuilder builder) {
            Matcher matcher = this.pattern.matcher(component);
            if (matcher.matches()) {
                this.process(matcher, builder);
                return true;
            }
            return false;
        }

        private TokenType(String pattern) {
            this.pattern = Pattern.compile(pattern);
        }
    }
}

