/*
 * Decompiled with CFR 0.152.
 */
package ratpack.registry;

import com.google.common.base.Predicate;
import com.google.common.reflect.TypeToken;
import java.util.Optional;
import ratpack.func.Action;
import ratpack.registry.NotInRegistryException;
import ratpack.registry.internal.EmptyRegistry;
import ratpack.registry.internal.HierarchicalRegistryCaching;

public interface Registry {
    default public <O> O get(Class<O> type) throws NotInRegistryException {
        return this.get(TypeToken.of(type));
    }

    default public <O> O get(TypeToken<O> type) throws NotInRegistryException {
        return this.maybeGet(type).orElseThrow(() -> new NotInRegistryException(type));
    }

    default public <O> Optional<O> maybeGet(Class<O> type) {
        return this.maybeGet(TypeToken.of(type));
    }

    public <O> Optional<O> maybeGet(TypeToken<O> var1);

    default public <O> Iterable<? extends O> getAll(Class<O> type) {
        return this.getAll(TypeToken.of(type));
    }

    public <O> Iterable<? extends O> getAll(TypeToken<O> var1);

    public <T> Optional<T> first(TypeToken<T> var1, Predicate<? super T> var2);

    public <T> Iterable<? extends T> all(TypeToken<T> var1, Predicate<? super T> var2);

    public <T> boolean each(TypeToken<T> var1, Predicate<? super T> var2, Action<? super T> var3) throws Exception;

    default public Registry join(Registry child) {
        if (this == EmptyRegistry.INSTANCE) {
            return child;
        }
        if (child == EmptyRegistry.INSTANCE) {
            return this;
        }
        return HierarchicalRegistryCaching.join(this, child);
    }
}

