/*
 * Decompiled with CFR 0.152.
 */
package ratpack.registry.internal;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.reflect.TypeToken;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import ratpack.func.Action;
import ratpack.registry.PredicateCacheability;
import ratpack.registry.Registry;
import ratpack.util.Types;

public class CachingRegistry
implements Registry {
    private final Registry delegate;
    private final ConcurrentMap<TypeToken<?>, Optional<?>> cache = new ConcurrentHashMap();
    private final ConcurrentMap<TypeToken<?>, Iterable<?>> allCache = new ConcurrentHashMap();
    private ConcurrentMap<PredicateCacheability.CacheKey<?>, Iterable<?>> predicateCache = new ConcurrentHashMap();

    public static Registry of(Registry registry) {
        if (registry instanceof CachingRegistry) {
            return registry;
        }
        return new CachingRegistry(registry);
    }

    private CachingRegistry(Registry delegate) {
        this.delegate = delegate;
    }

    private static <K, V> V compute(Map<K, V> map, K key, Function<? super K, ? extends V> supplier) {
        V value = map.get(key);
        if (value == null) {
            value = supplier.apply(key);
            map.put(key, value);
        }
        return value;
    }

    @Override
    public <O> Optional<O> maybeGet(TypeToken<O> type) {
        return (Optional)Types.cast(CachingRegistry.compute(this.cache, type, this.delegate::maybeGet));
    }

    public <O> Iterable<O> getAll(TypeToken<O> type) {
        return (Iterable)Types.cast(CachingRegistry.compute(this.allCache, type, this.delegate::getAll));
    }

    private <T> Iterable<? extends T> getFromPredicateCache(TypeToken<T> type, Predicate<? super T> predicate) {
        return (Iterable)Types.cast(CachingRegistry.compute(this.predicateCache, new PredicateCacheability.CacheKey<T>(type, predicate), k -> this.delegate.all(type, predicate)));
    }

    @Override
    public <T> Optional<T> first(TypeToken<T> type, Predicate<? super T> predicate) {
        if (PredicateCacheability.isCacheable(predicate)) {
            Iterable<? super T> objects = this.getFromPredicateCache(type, predicate);
            return Optional.ofNullable(Iterables.getFirst(objects, null));
        }
        return this.delegate.first(type, predicate);
    }

    @Override
    public <T> Iterable<? extends T> all(TypeToken<T> type, Predicate<? super T> predicate) {
        if (PredicateCacheability.isCacheable(predicate)) {
            return this.getFromPredicateCache(type, predicate);
        }
        return this.delegate.all(type, predicate);
    }

    @Override
    public <T> boolean each(TypeToken<T> type, Predicate<? super T> predicate, Action<? super T> action) throws Exception {
        Iterable<T> all = this.all(type, predicate);
        boolean any = false;
        for (T item : all) {
            any = true;
            action.execute(item);
        }
        return any;
    }

    public String toString() {
        return "CachingRegistry{delegate=" + this.delegate + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CachingRegistry that = (CachingRegistry)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }
}

