/*
 * Decompiled with CFR 0.152.
 */
package ratpack.registry.internal;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.google.common.reflect.TypeToken;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import ratpack.func.Action;
import ratpack.registry.MutableRegistry;
import ratpack.registry.NotInRegistryException;
import ratpack.registry.Registry;
import ratpack.registry.RegistrySpec;
import ratpack.registry.internal.DefaultRegistryEntry;
import ratpack.registry.internal.LazyRegistryEntry;
import ratpack.registry.internal.MultiEntryRegistry;
import ratpack.registry.internal.RegistryEntry;

public class SimpleMutableRegistry
implements MutableRegistry {
    private final List<RegistryEntry<?>> entries = new LinkedList();
    private final Registry registry = new MultiEntryRegistry(Lists.reverse(this.entries));

    @Override
    public <O> RegistrySpec addLazy(TypeToken<O> type, Supplier<? extends O> supplier) {
        this.entries.add(new LazyRegistryEntry<O>(type, supplier));
        return this;
    }

    @Override
    public <O> RegistrySpec add(TypeToken<? super O> type, O object) {
        this.entries.add(new DefaultRegistryEntry<O>(type, object));
        return this;
    }

    @Override
    public <T> void remove(TypeToken<T> type) throws NotInRegistryException {
        Iterator<RegistryEntry<?>> iterator = this.entries.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().getType().isAssignableFrom(type)) continue;
            iterator.remove();
        }
    }

    public <T> Optional<T> maybeGet(TypeToken<T> type) {
        return this.registry.maybeGet(type);
    }

    public <T> Iterable<? extends T> getAll(TypeToken<T> type) {
        return this.registry.getAll(type);
    }

    @Override
    public <T> Optional<T> first(TypeToken<T> type, Predicate<? super T> predicate) {
        return this.registry.first(type, predicate);
    }

    @Override
    public <T> Iterable<? extends T> all(TypeToken<T> type, Predicate<? super T> predicate) {
        return this.registry.all(type, predicate);
    }

    @Override
    public <T> boolean each(TypeToken<T> type, Predicate<? super T> predicate, Action<? super T> action) throws Exception {
        return this.registry.each(type, predicate, action);
    }
}

