/*
 * Decompiled with CFR 0.152.
 */
package ratpack.registry.internal;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.reflect.TypeToken;
import java.util.Collections;
import java.util.Optional;
import ratpack.func.Action;
import ratpack.registry.Registry;
import ratpack.registry.internal.RegistryEntry;

public class SingleEntryRegistry
implements Registry {
    private final RegistryEntry<?> entry;

    public SingleEntryRegistry(RegistryEntry<?> entry) {
        this.entry = entry;
    }

    @Override
    public <O> Optional<O> maybeGet(TypeToken<O> type) {
        if (type.isAssignableFrom(this.entry.getType())) {
            Object cast = this.entry.get();
            return Optional.of(cast);
        }
        return Optional.empty();
    }

    @Override
    public <O> Iterable<? extends O> getAll(TypeToken<O> type) {
        return this.maybeGet(type).map(o -> Collections.singleton(o)).orElse(Collections.emptySet());
    }

    @Override
    public <T> Optional<T> first(TypeToken<T> type, Predicate<? super T> predicate) {
        return this.maybeGet(type).filter(arg_0 -> predicate.apply(arg_0));
    }

    @Override
    public <T> Iterable<? extends T> all(TypeToken<T> type, Predicate<? super T> predicate) {
        return (Iterable)this.first(type, predicate).map(ImmutableList::of).orElse(ImmutableList.of());
    }

    @Override
    public <T> boolean each(TypeToken<T> type, Predicate<? super T> predicate, Action<? super T> action) throws Exception {
        Optional<T> first = this.first(type, predicate);
        if (!first.isPresent()) {
            return false;
        }
        action.execute(first.get());
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SingleEntryRegistry that = (SingleEntryRegistry)o;
        return this.entry.equals(that.entry);
    }

    public int hashCode() {
        return this.entry.hashCode();
    }

    public String toString() {
        return "SingleEntryRegistry{" + this.entry + '}';
    }
}

