/*
 * Decompiled with CFR 0.152.
 */
package ratpack.server.internal;

import com.google.common.collect.ImmutableSet;
import java.util.List;
import ratpack.server.CompressionConfig;
import ratpack.server.internal.DefaultCompressionConfig;

public class DefaultCompressionConfigBuilder
implements CompressionConfig.Builder {
    private boolean compressResponses;
    private long minSize = 1024L;
    private final ImmutableSet.Builder<String> mimeTypeWhiteList = ImmutableSet.builder();
    private final ImmutableSet.Builder<String> mimeTypeBlackList = ImmutableSet.builder();

    @Override
    public CompressionConfig.Builder compressResponses(boolean compressResponses) {
        this.compressResponses = compressResponses;
        return this;
    }

    @Override
    public CompressionConfig.Builder minSize(long minSize) {
        this.minSize = minSize;
        return this;
    }

    @Override
    public CompressionConfig.Builder whiteListMimeTypes(String ... mimeTypes) {
        this.mimeTypeWhiteList.add((Object[])mimeTypes);
        return this;
    }

    @Override
    public CompressionConfig.Builder whiteListMimeTypes(List<String> mimeTypes) {
        this.mimeTypeWhiteList.addAll(mimeTypes);
        return this;
    }

    @Override
    public CompressionConfig.Builder blackListMimeTypes(String ... mimeTypes) {
        this.mimeTypeBlackList.add((Object[])mimeTypes);
        return this;
    }

    @Override
    public CompressionConfig.Builder blackListMimeTypes(List<String> mimeTypes) {
        this.mimeTypeBlackList.addAll(mimeTypes);
        return this;
    }

    @Override
    public CompressionConfig build() {
        return new DefaultCompressionConfig(this.compressResponses, this.minSize, (ImmutableSet<String>)this.mimeTypeWhiteList.build(), (ImmutableSet<String>)this.mimeTypeBlackList.build());
    }
}

