/*
 * Decompiled with CFR 0.152.
 */
package ratpack.server.internal;

import java.net.InetAddress;
import java.net.URI;
import javax.net.ssl.SSLContext;
import ratpack.file.FileSystemBinding;
import ratpack.server.NoBaseDirException;
import ratpack.server.ServerConfig;

public class DefaultServerConfig
implements ServerConfig {
    private final FileSystemBinding baseDir;
    private final int port;
    private final InetAddress address;
    private final boolean development;
    private final int threads;
    private final URI publicAddress;
    private final SSLContext sslContext;
    private final int maxContentLength;

    public DefaultServerConfig(FileSystemBinding baseDir, int port, InetAddress address, boolean development, int threads, URI publicAddress, SSLContext sslContext, int maxContentLength) {
        this.baseDir = baseDir;
        this.port = port;
        this.address = address;
        this.development = development;
        this.threads = threads;
        this.publicAddress = publicAddress;
        this.sslContext = sslContext;
        this.maxContentLength = maxContentLength;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public InetAddress getAddress() {
        return this.address;
    }

    @Override
    public boolean isDevelopment() {
        return this.development;
    }

    @Override
    public int getThreads() {
        return this.threads;
    }

    @Override
    public URI getPublicAddress() {
        return this.publicAddress;
    }

    @Override
    public SSLContext getSSLContext() {
        return this.sslContext;
    }

    @Override
    public int getMaxContentLength() {
        return this.maxContentLength;
    }

    @Override
    public boolean isHasBaseDir() {
        return this.baseDir != null;
    }

    @Override
    public FileSystemBinding getBaseDir() throws NoBaseDirException {
        if (this.baseDir == null) {
            throw new NoBaseDirException("No base dir has been set");
        }
        return this.baseDir;
    }
}

