/*
 * Decompiled with CFR 0.152.
 */
package ratpack.exec;

import ratpack.exec.ExecResult;
import ratpack.exec.internal.DefaultResult;
import ratpack.exec.internal.ResultBackedExecResult;
import ratpack.util.Exceptions;

public interface Result<T> {
    public static <T> Result<T> success(T value) {
        return new DefaultResult<T>(value);
    }

    public static <T> Result<T> failure(Throwable failure) {
        return new DefaultResult(failure);
    }

    public Throwable getThrowable();

    public T getValue();

    public boolean isSuccess();

    public boolean isFailure();

    default public T getValueOrThrow() throws Exception {
        if (this.isFailure()) {
            throw Exceptions.toException(this.getThrowable());
        }
        return this.getValue();
    }

    default public ExecResult<T> toExecResult() {
        return new ResultBackedExecResult(this);
    }
}

