/*
 * Decompiled with CFR 0.152.
 */
package ratpack.exec.internal;

import com.google.common.collect.Lists;
import io.netty.channel.EventLoop;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ratpack.exec.ExecController;
import ratpack.exec.ExecInterceptor;
import ratpack.exec.Execution;
import ratpack.exec.ExecutionException;
import ratpack.exec.UnmanagedThreadException;
import ratpack.exec.internal.DefaultExecution;
import ratpack.func.Action;
import ratpack.func.NoArgAction;

public class ExecutionBacking {
    static final Logger LOGGER = LoggerFactory.getLogger(Execution.class);
    public static final boolean TRACE = Boolean.getBoolean("ratpack.execution.trace");
    private static final ThreadLocal<ExecutionBacking> THREAD_BINDING = new ThreadLocal();
    final List<ExecInterceptor> interceptors = Lists.newLinkedList();
    Queue<Deque<NoArgAction>> stream = new ConcurrentLinkedQueue<Deque<NoArgAction>>();
    private final EventLoop eventLoop;
    private final List<AutoCloseable> closeables = Lists.newLinkedList();
    private final Action<? super Throwable> onError;
    private final Action<? super Execution> onComplete;
    private volatile boolean done;
    private final Execution execution;

    public ExecutionBacking(ExecController controller, EventLoop eventLoop, Optional<StackTraceElement[]> startTrace, Action<? super Execution> action, Action<? super Throwable> onError, Action<? super Execution> onComplete) {
        this.eventLoop = eventLoop;
        this.onError = onError;
        this.onComplete = onComplete;
        this.execution = new DefaultExecution(eventLoop, controller, this.closeables);
        LinkedList event = Lists.newLinkedList();
        event.add(() -> action.execute(this.execution));
        this.stream.add(event);
        LinkedList doneEvent = Lists.newLinkedList();
        doneEvent.add(() -> {
            this.done = true;
        });
        this.stream.add(doneEvent);
        this.drain();
    }

    public static ExecutionBacking get() throws UnmanagedThreadException {
        return THREAD_BINDING.get();
    }

    public static ExecutionBacking require() throws UnmanagedThreadException {
        ExecutionBacking executionBacking = ExecutionBacking.get();
        if (executionBacking == null) {
            throw new UnmanagedThreadException();
        }
        return executionBacking;
    }

    public Execution getExecution() {
        return this.execution;
    }

    public EventLoop getEventLoop() {
        return this.eventLoop;
    }

    public List<ExecInterceptor> getInterceptors() {
        return this.interceptors;
    }

    public void streamSubscribe(Consumer<? super StreamHandle> consumer) {
        this.stream.element().add(() -> {
            Queue<Deque<NoArgAction>> parent = this.stream;
            this.stream = new ConcurrentLinkedDeque<Deque<NoArgAction>>();
            this.stream.add(Lists.newLinkedList());
            StreamHandle handle = new StreamHandle(parent, this.stream);
            consumer.accept(handle);
        });
        this.drain();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drain() {
        ExecutionBacking threadBoundExecutionBacking = THREAD_BINDING.get();
        if (this.equals(threadBoundExecutionBacking)) {
            return;
        }
        if (this.done) {
            throw new ExecutionException("execution is complete");
        }
        if (!this.eventLoop.inEventLoop() || threadBoundExecutionBacking != null) {
            this.eventLoop.execute(this::drain);
            return;
        }
        try {
            THREAD_BINDING.set(this);
            while (true) {
                if (this.stream.isEmpty()) {
                    return;
                }
                NoArgAction segment = this.stream.element().poll();
                if (segment == null) {
                    this.stream.remove();
                    if (!this.stream.isEmpty()) continue;
                    if (this.done) {
                        this.done();
                        return;
                    }
                    break;
                }
                if (segment instanceof UserCode) {
                    try {
                        this.intercept(ExecInterceptor.ExecType.COMPUTE, this.interceptors, segment);
                    }
                    catch (Throwable e) {
                        Deque<NoArgAction> event = this.stream.element();
                        event.clear();
                        event.addFirst(() -> {
                            try {
                                this.onError.execute(e);
                            }
                            catch (Throwable errorHandlerException) {
                                this.stream.element().addFirst(() -> {
                                    throw errorHandlerException;
                                });
                            }
                        });
                    }
                    continue;
                }
                try {
                    segment.execute();
                }
                catch (Exception e) {
                    LOGGER.error("Internal Ratpack Error - please raise an issue", (Throwable)e);
                }
            }
        }
        finally {
            THREAD_BINDING.remove();
        }
    }

    private void done() {
        try {
            this.onComplete.execute(this.getExecution());
        }
        catch (Throwable e) {
            LOGGER.warn("exception raised during onComplete action", e);
        }
        for (AutoCloseable closeable : this.closeables) {
            try {
                closeable.close();
            }
            catch (Throwable e) {
                LOGGER.warn(String.format("exception raised by closeable %s", closeable), e);
            }
        }
    }

    public void intercept(ExecInterceptor.ExecType execType, List<ExecInterceptor> interceptors, NoArgAction action) throws Exception {
        if (interceptors.isEmpty()) {
            action.execute();
        } else {
            ExecutionBacking.nextInterceptor(this.execution, action, execType, interceptors.iterator());
        }
    }

    private static void nextInterceptor(Execution execution, NoArgAction action, ExecInterceptor.ExecType type, Iterator<ExecInterceptor> interceptors) throws Exception {
        if (interceptors.hasNext()) {
            interceptors.next().intercept(execution, type, () -> ExecutionBacking.nextInterceptor(execution, action, type, interceptors));
        } else {
            action.execute();
        }
    }

    public class StreamHandle {
        final Queue<Deque<NoArgAction>> parent;
        final Queue<Deque<NoArgAction>> stream;

        private StreamHandle(Queue<Deque<NoArgAction>> parent, Queue<Deque<NoArgAction>> stream) {
            this.parent = parent;
            this.stream = stream;
        }

        public void event(UserCode action) {
            this.streamEvent(action);
        }

        public void complete(UserCode action) {
            this.streamEvent(() -> {
                ExecutionBacking.this.stream = this.parent;
                action.execute();
            });
        }

        private void streamEvent(NoArgAction s) {
            LinkedList event = Lists.newLinkedList();
            event.add(s);
            this.stream.add(event);
            ExecutionBacking.this.drain();
        }
    }

    public static interface UserCode
    extends NoArgAction {
    }
}

