/*
 * Decompiled with CFR 0.152.
 */
package ratpack.health;

import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Maps;
import com.google.common.reflect.TypeToken;
import java.util.Collections;
import java.util.Iterator;
import java.util.Optional;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import ratpack.exec.ExecControl;
import ratpack.exec.Promise;
import ratpack.exec.Throttle;
import ratpack.handling.Context;
import ratpack.handling.Handler;
import ratpack.health.HealthCheck;
import ratpack.health.HealthCheckResults;

public class HealthCheckHandler
implements Handler {
    public static final String DEFAULT_NAME_TOKEN = "name";
    private static final TypeToken<HealthCheck> HEALTH_CHECK_TYPE_TOKEN = TypeToken.of(HealthCheck.class);
    private final String name;
    private final Throttle throttle;

    public HealthCheckHandler() {
        this(DEFAULT_NAME_TOKEN, Throttle.unlimited());
    }

    public HealthCheckHandler(String pathTokenName) {
        this(pathTokenName, Throttle.unlimited());
    }

    public HealthCheckHandler(Throttle throttle) {
        this(DEFAULT_NAME_TOKEN, throttle);
    }

    protected HealthCheckHandler(String pathTokenName, Throttle throttle) {
        this.name = pathTokenName;
        this.throttle = throttle;
    }

    public Throttle getThrottle() {
        return this.throttle;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void handle(Context ctx) {
        ctx.getResponse().getHeaders().add("Cache-Control", "no-cache, no-store, must-revalidate").add("Pragma", "no-cache").add("Expires", 0);
        try {
            String checkName = (String)ctx.getPathTokens().get(this.name);
            if (checkName != null) {
                Optional<HealthCheck> first = ctx.first(HEALTH_CHECK_TYPE_TOKEN, healthCheck -> healthCheck.getName().equals(checkName) ? healthCheck : null);
                if (first.isPresent()) {
                    ctx.render(this.execute((ExecControl)ctx, Collections.singleton(first.get())));
                } else {
                    ctx.clientError(404);
                }
            } else {
                ctx.render(this.execute((ExecControl)ctx, ctx.getAll(HEALTH_CHECK_TYPE_TOKEN)));
            }
        }
        catch (Exception e) {
            ctx.error(e);
        }
    }

    private Promise<HealthCheck.Result> execute(ExecControl execControl, HealthCheck healthCheck) {
        try {
            return healthCheck.check(execControl).mapError(HealthCheck.Result::unhealthy);
        }
        catch (Exception e) {
            return execControl.promiseOf(HealthCheck.Result.unhealthy(e));
        }
    }

    private Promise<HealthCheckResults> execute(ExecControl execControl, Iterable<? extends HealthCheck> healthChecks) {
        Iterator<? extends HealthCheck> iterator = healthChecks.iterator();
        if (!iterator.hasNext()) {
            return execControl.promiseOf(new HealthCheckResults((ImmutableSortedMap<String, HealthCheck.Result>)ImmutableSortedMap.of()));
        }
        return execControl.promise(f -> {
            AtomicInteger counter = new AtomicInteger();
            ConcurrentMap results = Maps.newConcurrentMap();
            while (iterator.hasNext()) {
                counter.incrementAndGet();
                HealthCheck healthCheck = (HealthCheck)iterator.next();
                execControl.exec().start(e -> this.execute((ExecControl)e, healthCheck).throttled(this.throttle).then(r -> {
                    results.put(healthCheck.getName(), r);
                    if (counter.decrementAndGet() == 0 && !iterator.hasNext()) {
                        f.success(results);
                    }
                }));
            }
        }).map(ImmutableSortedMap::copyOf).map(HealthCheckResults::new);
    }
}

