/*
 * Decompiled with CFR 0.152.
 */
package ratpack.path.internal;

import com.google.common.collect.ImmutableList;
import java.util.regex.Pattern;
import ratpack.path.PathBinder;
import ratpack.path.PathBinderBuilder;
import ratpack.path.internal.TokenPathBinder;

public class DefaultPathBinderBuilder
implements PathBinderBuilder {
    private ImmutableList.Builder<String> tokensBuilder = ImmutableList.builder();
    private StringBuilder pattern = new StringBuilder();
    private boolean addedOptional;
    private boolean addedToken;

    @Override
    public PathBinderBuilder tokenWithPattern(String token, String pattern) {
        if (this.addedOptional) {
            throw new IllegalArgumentException(String.format("Cannot add mandatory parameter %s after optional parameters", token));
        }
        this.addedToken = true;
        this.tokensBuilder.add((Object)token);
        this.pattern.append(String.format("(?:(?:^|/)(%s))", pattern));
        return this;
    }

    @Override
    public PathBinderBuilder optionalTokenWithPattern(String token, String pattern) {
        this.addedOptional = true;
        this.addedToken = true;
        this.tokensBuilder.add((Object)token);
        this.pattern.append(String.format("(?:(?:^|/)(%s))?", pattern));
        return this;
    }

    @Override
    public PathBinderBuilder token(String token) {
        if (this.addedOptional) {
            throw new IllegalArgumentException(String.format("Cannot add mandatory parameter %s after optional parameters", token));
        }
        this.addedToken = true;
        this.tokensBuilder.add((Object)token);
        this.pattern.append("(?:(?:^|/)([^/?&#]+))");
        return this;
    }

    @Override
    public PathBinderBuilder optionalToken(String token) {
        this.addedOptional = true;
        this.addedToken = true;
        this.tokensBuilder.add((Object)token);
        this.pattern.append("(?:(?:^|/)([^/?&#]*))?");
        return this;
    }

    @Override
    public PathBinderBuilder literalPattern(String pattern) {
        this.pattern.append("(?:(?:^|/)").append(String.format("(?:%s)", pattern)).append(")");
        return this;
    }

    @Override
    public PathBinderBuilder literal(String literal) {
        this.pattern.append(String.format("\\Q%s\\E", literal));
        return this;
    }

    @Override
    public PathBinder build(boolean exact) {
        String regex = (this.addedToken ? "(\\Q\\E" : "(") + this.pattern + (this.addedToken ? "\\Q\\E)" : ")") + (exact ? "(?:/|$)" : "(?:/.*)?");
        Pattern compiled = Pattern.compile(regex);
        return new TokenPathBinder((ImmutableList<String>)this.tokensBuilder.build(), compiled);
    }
}

