/*
 * Decompiled with CFR 0.152.
 */
package ratpack.registry;

import com.google.common.reflect.TypeToken;
import java.util.Optional;
import ratpack.func.Function;
import ratpack.registry.NotInRegistryException;
import ratpack.registry.internal.EmptyRegistry;
import ratpack.registry.internal.HierarchicalRegistryCaching;

public interface Registry {
    default public <O> O get(Class<O> type) throws NotInRegistryException {
        return this.get(TypeToken.of(type));
    }

    default public <O> O get(TypeToken<O> type) throws NotInRegistryException {
        return this.maybeGet(type).orElseThrow(() -> new NotInRegistryException(type));
    }

    default public <O> Optional<O> maybeGet(Class<O> type) {
        return this.maybeGet(TypeToken.of(type));
    }

    public <O> Optional<O> maybeGet(TypeToken<O> var1);

    default public <O> Iterable<? extends O> getAll(Class<O> type) {
        return this.getAll(TypeToken.of(type));
    }

    public <O> Iterable<? extends O> getAll(TypeToken<O> var1);

    default public <T, O> Optional<O> first(TypeToken<T> type, Function<? super T, ? extends O> function) throws Exception {
        Iterable<T> all = this.getAll(type);
        for (T t : all) {
            O out = function.apply(t);
            if (out == null) continue;
            return Optional.of(out);
        }
        return Optional.empty();
    }

    default public Registry join(Registry child) {
        if (this == EmptyRegistry.INSTANCE) {
            return child;
        }
        if (child == EmptyRegistry.INSTANCE) {
            return this;
        }
        return HierarchicalRegistryCaching.join(this, child);
    }
}

