/*
 * Decompiled with CFR 0.152.
 */
package ratpack.server;

import com.google.common.io.ByteSource;
import java.io.File;
import java.net.InetAddress;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.util.Map;
import java.util.Properties;
import javax.net.ssl.SSLContext;
import ratpack.file.FileSystemBinding;
import ratpack.server.NoBaseDirException;
import ratpack.server.ServerEnvironment;
import ratpack.server.internal.DefaultServerConfigBuilder;

public interface ServerConfig {
    public static final int DEFAULT_PORT = 5050;
    public static final int DEFAULT_MAX_CONTENT_LENGTH = 0x100000;
    public static final int DEFAULT_THREADS = Runtime.getRuntime().availableProcessors() * 2;

    public static Builder embedded() {
        return ServerConfig.noBaseDir().development(true).port(0);
    }

    public static Builder embedded(Path baseDir) {
        return ServerConfig.baseDir(baseDir).development(true).port(0);
    }

    public static Builder noBaseDir() {
        return DefaultServerConfigBuilder.noBaseDir(ServerEnvironment.env());
    }

    public static Builder findBaseDirProps() {
        return ServerConfig.findBaseDirProps("ratpack.properties");
    }

    public static Builder findBaseDirProps(String propertiesPath) {
        return DefaultServerConfigBuilder.findBaseDirProps(ServerEnvironment.env(), propertiesPath);
    }

    public static Builder baseDir(Path baseDir) {
        return DefaultServerConfigBuilder.baseDir(ServerEnvironment.env(), baseDir);
    }

    public static Builder baseDir(File baseDir) {
        return ServerConfig.baseDir(baseDir.toPath());
    }

    public int getPort();

    public InetAddress getAddress();

    public boolean isDevelopment();

    public int getThreads();

    public URI getPublicAddress();

    public SSLContext getSSLContext();

    public int getMaxContentLength();

    public boolean isHasBaseDir();

    public FileSystemBinding getBaseDir() throws NoBaseDirException;

    public static interface Builder {
        public static final String DEFAULT_ENV_PREFIX = "RATPACK_";
        public static final String DEFAULT_PROP_PREFIX = "ratpack.";
        public static final String DEFAULT_PROPERTIES_FILE_NAME = "ratpack.properties";

        public Builder port(int var1);

        public Builder address(InetAddress var1);

        public Builder development(boolean var1);

        public Builder threads(int var1);

        public Builder publicAddress(URI var1);

        public Builder maxContentLength(int var1);

        public Builder ssl(SSLContext var1);

        public Builder env();

        public Builder env(String var1);

        public Builder props(ByteSource var1);

        public Builder props(String var1);

        public Builder props(Path var1);

        public Builder props(Properties var1);

        public Builder props(Map<String, String> var1);

        public Builder props(URL var1);

        public Builder sysProps();

        public Builder sysProps(String var1);

        public ServerConfig build();
    }
}

