/*
 * Decompiled with CFR 0.152.
 */
package ratpack.config.internal;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TreeTraversingParser;
import java.io.IOException;
import ratpack.config.ConfigData;
import ratpack.config.ConfigDataSpec;
import ratpack.config.internal.ConfigDataLoader;
import ratpack.config.internal.ConfigDataReloadInformant;
import ratpack.registry.Registry;
import ratpack.server.StartEvent;
import ratpack.server.StopEvent;
import ratpack.util.Exceptions;

public class DefaultConfigData
implements ConfigData {
    private final ObjectMapper objectMapper;
    private final ObjectNode rootNode;
    private final ConfigDataReloadInformant reloadInformant;
    private final ObjectNode emptyNode;

    public DefaultConfigData(ConfigDataSpec configDataSpec) {
        this.objectMapper = configDataSpec.getObjectMapper();
        ConfigDataLoader loader = new ConfigDataLoader(this.objectMapper, configDataSpec.getConfigSources());
        this.rootNode = loader.load();
        this.reloadInformant = new ConfigDataReloadInformant(this.rootNode, loader);
        this.emptyNode = this.objectMapper.getNodeFactory().objectNode();
    }

    @Override
    public <O> O get(String pointer, Class<O> type) {
        ObjectNode node;
        Object object = node = pointer != null ? this.rootNode.at(pointer) : this.rootNode;
        if (node.isMissingNode()) {
            node = this.emptyNode;
        }
        try {
            return (O)this.objectMapper.readValue((JsonParser)new TreeTraversingParser((JsonNode)node, (ObjectCodec)this.objectMapper), type);
        }
        catch (IOException ex) {
            throw Exceptions.uncheck(ex);
        }
    }

    @Override
    public boolean shouldReload(Registry registry) {
        return this.reloadInformant.shouldReload(registry);
    }

    @Override
    public void onStart(StartEvent event) throws Exception {
        this.reloadInformant.onStart(event);
    }

    @Override
    public void onStop(StopEvent event) throws Exception {
        this.reloadInformant.onStop(event);
    }
}

