/*
 * Decompiled with CFR 0.152.
 */
package ratpack.exec;

import java.util.concurrent.Callable;
import org.reactivestreams.Publisher;
import ratpack.exec.ExecController;
import ratpack.exec.ExecInterceptor;
import ratpack.exec.ExecStarter;
import ratpack.exec.Execution;
import ratpack.exec.Fulfiller;
import ratpack.exec.Promise;
import ratpack.exec.UnmanagedThreadException;
import ratpack.exec.internal.JustInTimeExecControl;
import ratpack.func.Action;
import ratpack.func.Block;
import ratpack.func.Factory;
import ratpack.stream.TransformablePublisher;

public interface ExecControl {
    public static ExecControl current() throws UnmanagedThreadException {
        return ExecController.require().getControl();
    }

    public static ExecControl execControl() {
        return JustInTimeExecControl.INSTANCE;
    }

    public Execution getExecution() throws UnmanagedThreadException;

    public ExecController getController();

    public void addInterceptor(ExecInterceptor var1, Block var2) throws Exception;

    public <T> Promise<T> blocking(Callable<T> var1);

    public <T> Promise<T> promise(Action<? super Fulfiller<T>> var1);

    default public <T> Promise<T> promiseOf(T item) {
        return this.promise(f -> f.success(item));
    }

    default public <T> Promise<T> failedPromise(Throwable error) {
        return this.promise(f -> f.error(error));
    }

    default public <T> Promise<T> wrap(Factory<? extends Promise<T>> factory) {
        try {
            return factory.create();
        }
        catch (Exception e) {
            return this.failedPromise(e);
        }
    }

    default public void nest(Block nested, Block then) {
        this.nest(nested, then, Action.noop());
    }

    default public void nest(Block nested, Block then, Action<? super Throwable> onError) {
        this.promise(f -> {
            nested.execute();
            f.success(null);
        }).onError(onError).then(v -> then.execute());
    }

    public ExecStarter exec();

    public <T> TransformablePublisher<T> stream(Publisher<T> var1);
}

