/*
 * Decompiled with CFR 0.152.
 */
package ratpack.exec.internal;

import io.netty.channel.EventLoopGroup;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import ratpack.exec.ExecController;
import ratpack.exec.internal.DefaultExecControl;
import ratpack.exec.internal.ExecControlInternal;
import ratpack.exec.internal.ExecControllerThreadBinding;
import ratpack.util.internal.ChannelImplDetector;

public class DefaultExecController
implements ExecController {
    private final ExecutorService blockingExecutor;
    private final EventLoopGroup eventLoopGroup;
    private final DefaultExecControl control;
    private final int numThreads;

    public DefaultExecController() {
        this(Runtime.getRuntime().availableProcessors() * 2);
    }

    public DefaultExecController(int numThreads) {
        this.numThreads = numThreads;
        this.eventLoopGroup = ChannelImplDetector.eventLoopGroup(numThreads, (ThreadFactory)((Object)new ExecControllerBindingThreadFactory("ratpack-compute", 10)));
        this.blockingExecutor = Executors.newCachedThreadPool((ThreadFactory)((Object)new ExecControllerBindingThreadFactory("ratpack-blocking", 5)));
        this.control = new DefaultExecControl(this);
    }

    @Override
    public void close() {
        this.eventLoopGroup.shutdownGracefully(0L, 0L, TimeUnit.SECONDS);
        this.blockingExecutor.shutdown();
    }

    @Override
    public ScheduledExecutorService getExecutor() {
        return this.eventLoopGroup;
    }

    @Override
    public ExecutorService getBlockingExecutor() {
        return this.blockingExecutor;
    }

    @Override
    public EventLoopGroup getEventLoopGroup() {
        return this.eventLoopGroup;
    }

    @Override
    public ExecControlInternal getControl() {
        return this.control;
    }

    @Override
    public boolean isManagedThread() {
        return ExecControllerThreadBinding.get().map(c -> c == this).orElse(false);
    }

    @Override
    public int getNumThreads() {
        return this.numThreads;
    }

    private class ExecControllerBindingThreadFactory
    extends DefaultThreadFactory {
        public ExecControllerBindingThreadFactory(String name, int priority) {
            super(name, priority);
        }

        public Thread newThread(Runnable r) {
            return super.newThread(() -> {
                ExecControllerThreadBinding.set(DefaultExecController.this);
                r.run();
            });
        }
    }
}

