/*
 * Decompiled with CFR 0.152.
 */
package ratpack.exec.internal;

import ratpack.exec.Downstream;
import ratpack.exec.ExecutionException;
import ratpack.exec.Promise;
import ratpack.exec.Upstream;
import ratpack.exec.internal.ExecutionBacking;
import ratpack.func.Action;
import ratpack.func.Function;
import ratpack.util.Exceptions;
import ratpack.util.internal.InternalRatpackError;

public class DefaultPromise<T>
implements Promise<T> {
    private final Upstream<T> upstream;

    public DefaultPromise(Upstream<T> upstream) {
        this.upstream = upstream;
    }

    @Override
    public void then(final Action<? super T> then) {
        try {
            this.upstream.connect(new Downstream<T>(){

                @Override
                public void success(T value) {
                    try {
                        then.execute(value);
                    }
                    catch (Throwable e) {
                        DefaultPromise.this.throwError(e);
                    }
                }

                @Override
                public void error(Throwable throwable) {
                    DefaultPromise.this.throwError(throwable);
                }

                @Override
                public void complete() {
                }
            });
        }
        catch (ExecutionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InternalRatpackError("failed to add promise resume action", e);
        }
    }

    private void throwError(Throwable throwable) {
        ExecutionBacking.require().streamSubscribe(h -> h.complete(() -> {
            throw Exceptions.toException(throwable);
        }));
    }

    @Override
    public <O> Promise<O> transform(Function<? super Upstream<? extends T>, ? extends Upstream<O>> upstreamTransformer) {
        try {
            return new DefaultPromise<O>(upstreamTransformer.apply(this.upstream));
        }
        catch (Exception e) {
            throw Exceptions.uncheck(e);
        }
    }
}

