/*
 * Decompiled with CFR 0.152.
 */
package ratpack.exec.internal;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import io.netty.channel.EventLoop;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ratpack.exec.ExecController;
import ratpack.exec.ExecInterceptor;
import ratpack.exec.Execution;
import ratpack.exec.ExecutionException;
import ratpack.exec.UnmanagedThreadException;
import ratpack.exec.internal.DefaultExecution;
import ratpack.func.Action;
import ratpack.func.BiAction;
import ratpack.func.Block;
import ratpack.registry.RegistrySpec;

public class ExecutionBacking {
    static final Logger LOGGER = LoggerFactory.getLogger(Execution.class);
    private static final ThreadLocal<ExecutionBacking> THREAD_BINDING = new ThreadLocal();
    private final ImmutableList<? extends ExecInterceptor> globalInterceptors;
    private final ImmutableList<? extends ExecInterceptor> registryInterceptors;
    private List<ExecInterceptor> adhocInterceptors;
    Queue<Deque<Block>> stream = new ConcurrentLinkedQueue<Deque<Block>>();
    private final EventLoop eventLoop;
    private final List<AutoCloseable> closeables = Lists.newArrayList();
    private final BiAction<? super Execution, ? super Throwable> onError;
    private final Action<? super Execution> onComplete;
    private volatile boolean done;
    private final Execution execution;

    public ExecutionBacking(ExecController controller, EventLoop eventLoop, ImmutableList<? extends ExecInterceptor> globalInterceptors, Action<? super RegistrySpec> registry, Action<? super Execution> action, BiAction<? super Execution, ? super Throwable> onError, Action<? super Execution> onComplete) throws Exception {
        this.eventLoop = eventLoop;
        this.onError = onError;
        this.onComplete = onComplete;
        this.execution = new DefaultExecution(eventLoop, controller, this.closeables);
        registry.execute(this.execution);
        this.registryInterceptors = ImmutableList.copyOf(this.execution.getAll(ExecInterceptor.class));
        this.globalInterceptors = globalInterceptors;
        ArrayDeque<UserCode> event = new ArrayDeque<UserCode>();
        event.add(() -> action.execute(this.execution));
        this.stream.add(event);
        ArrayDeque<Block> doneEvent = new ArrayDeque<Block>(1);
        doneEvent.add(() -> {
            this.done = true;
        });
        this.stream.add(doneEvent);
        this.drain();
    }

    public static ExecutionBacking get() throws UnmanagedThreadException {
        return THREAD_BINDING.get();
    }

    public static ExecutionBacking require() throws UnmanagedThreadException {
        ExecutionBacking executionBacking = ExecutionBacking.get();
        if (executionBacking == null) {
            throw new UnmanagedThreadException();
        }
        return executionBacking;
    }

    public Execution getExecution() {
        return this.execution;
    }

    public EventLoop getEventLoop() {
        return this.eventLoop;
    }

    public void addInterceptor(ExecInterceptor interceptor) {
        if (this.adhocInterceptors == null) {
            this.adhocInterceptors = Lists.newArrayList();
        }
        this.adhocInterceptors.add(interceptor);
    }

    public void streamSubscribe(Consumer<? super StreamHandle> consumer) {
        if (this.done) {
            throw new ExecutionException("this execution has completed (you may be trying to use a promise in a cleanup method)");
        }
        this.stream.element().add(() -> {
            Queue<Deque<Block>> parent = this.stream;
            this.stream = new ConcurrentLinkedDeque<Deque<Block>>();
            this.stream.add(new ArrayDeque());
            StreamHandle handle = new StreamHandle(parent, this.stream);
            consumer.accept(handle);
        });
        this.drain();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drain() {
        if (this.done) {
            return;
        }
        ExecutionBacking threadBoundExecutionBacking = THREAD_BINDING.get();
        if (this.equals(threadBoundExecutionBacking)) {
            return;
        }
        if (!this.eventLoop.inEventLoop() || threadBoundExecutionBacking != null) {
            if (!this.done) {
                this.eventLoop.execute(this::drain);
            }
            return;
        }
        try {
            THREAD_BINDING.set(this);
            while (true) {
                if (this.stream.isEmpty()) {
                    return;
                }
                Block segment = this.stream.element().poll();
                if (segment == null) {
                    this.stream.remove();
                    if (!this.stream.isEmpty()) continue;
                    if (this.done) {
                        this.done();
                        return;
                    }
                    break;
                }
                if (segment instanceof UserCode) {
                    try {
                        this.intercept(ExecInterceptor.ExecType.COMPUTE, this.getAllInterceptors().iterator(), segment);
                    }
                    catch (Throwable e) {
                        Deque<Block> event = this.stream.element();
                        event.clear();
                        event.addFirst(() -> {
                            try {
                                this.onError.execute(this.execution, e);
                            }
                            catch (Throwable errorHandlerException) {
                                this.stream.element().addFirst(() -> {
                                    throw errorHandlerException;
                                });
                            }
                        });
                    }
                    continue;
                }
                try {
                    segment.execute();
                }
                catch (Exception e) {
                    LOGGER.error("Internal Ratpack Error - please raise an issue", (Throwable)e);
                }
            }
        }
        finally {
            THREAD_BINDING.remove();
        }
    }

    public Iterable<? extends ExecInterceptor> getAllInterceptors() {
        Iterable interceptors = this.adhocInterceptors == null ? Iterables.concat(this.globalInterceptors, this.registryInterceptors) : Iterables.concat(this.globalInterceptors, this.registryInterceptors, this.adhocInterceptors);
        return interceptors;
    }

    private void done() {
        try {
            this.onComplete.execute(this.getExecution());
        }
        catch (Throwable e) {
            LOGGER.warn("exception raised during onComplete action", e);
        }
        for (AutoCloseable closeable : this.closeables) {
            try {
                closeable.close();
            }
            catch (Throwable e) {
                LOGGER.warn(String.format("exception raised by closeable %s", closeable), e);
            }
        }
    }

    public void intercept(ExecInterceptor.ExecType execType, Iterator<? extends ExecInterceptor> interceptors, Block action) throws Exception {
        if (interceptors.hasNext()) {
            interceptors.next().intercept(this.execution, execType, () -> this.intercept(execType, interceptors, action));
        } else {
            action.execute();
        }
    }

    public class StreamHandle {
        final Queue<Deque<Block>> parent;
        final Queue<Deque<Block>> stream;

        private StreamHandle(Queue<Deque<Block>> parent, Queue<Deque<Block>> stream) {
            this.parent = parent;
            this.stream = stream;
        }

        public void event(UserCode action) {
            this.streamEvent(action);
        }

        public void complete(UserCode action) {
            this.streamEvent(() -> {
                ExecutionBacking.this.stream = this.parent;
                action.execute();
            });
        }

        private void streamEvent(Block s) {
            ArrayDeque<Block> event = new ArrayDeque<Block>();
            event.add(s);
            this.stream.add(event);
            ExecutionBacking.this.drain();
        }
    }

    public static interface UserCode
    extends Block {
    }
}

