/*
 * Decompiled with CFR 0.152.
 */
package ratpack.registry.internal;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import ratpack.registry.Registry;
import ratpack.registry.internal.CachingRegistry;
import ratpack.registry.internal.HierarchicalRegistry;

public class HierarchicalRegistryCaching {
    private static final ReferenceQueue<Registry> REFERENCE_QUEUE = new ReferenceQueue();
    private static final ConcurrentMap<CacheKey, Registry> CACHE = new ConcurrentHashMap<CacheKey, Registry>();

    public static Registry join(Registry parent, Registry child) {
        CacheKey cacheKey = new CacheKey(new WeakReference<Registry>(parent, REFERENCE_QUEUE), new WeakReference<Registry>(child, REFERENCE_QUEUE));
        Registry registry = CACHE.computeIfAbsent(cacheKey, k -> CachingRegistry.of(new HierarchicalRegistry(parent, child)));
        Reference<Registry> collected = REFERENCE_QUEUE.poll();
        while (collected != null) {
            Iterator iterator = CACHE.keySet().iterator();
            while (iterator.hasNext()) {
                CacheKey k2 = (CacheKey)iterator.next();
                if (k2.parent != collected && k2.child != collected) continue;
                iterator.remove();
            }
            collected = REFERENCE_QUEUE.poll();
        }
        return registry;
    }

    private static class CacheKey {
        final WeakReference<Registry> parent;
        final WeakReference<Registry> child;
        final int parentHashCode;
        final int childHashCode;

        public CacheKey(WeakReference<Registry> parent, WeakReference<Registry> child) {
            this.parent = parent;
            this.child = child;
            this.parentHashCode = System.identityHashCode(parent.get());
            this.childHashCode = System.identityHashCode(child.get());
        }

        public boolean equals(Object o) {
            Registry parentRegistry = (Registry)this.parent.get();
            if (parentRegistry == null) {
                return false;
            }
            Registry childRegistry = (Registry)this.child.get();
            if (childRegistry == null) {
                return false;
            }
            CacheKey other = (CacheKey)o;
            return parentRegistry.equals(other.parent.get()) && childRegistry.equals(other.child.get());
        }

        public int hashCode() {
            return 31 * this.parentHashCode + this.childHashCode;
        }
    }
}

