/*
 * Decompiled with CFR 0.152.
 */
package ratpack.render.internal;

import com.google.common.reflect.TypeToken;
import ratpack.handling.Context;
import ratpack.render.NoSuchRendererException;
import ratpack.render.RenderableDecorator;
import ratpack.render.Renderer;
import ratpack.render.RendererException;
import ratpack.render.internal.RenderController;
import ratpack.util.Types;

public class DefaultRenderController
implements RenderController {
    private static final TypeToken<Renderer<?>> RENDERER_TYPE = new TypeToken<Renderer<?>>(){};
    private static final TypeToken<RenderableDecorator<?>> RENDERABLE_DECORATOR_TYPE = new TypeToken<RenderableDecorator<?>>(){};

    @Override
    public void render(Object toRender, Context context) throws Exception {
        if (toRender == null) {
            context.clientError(404);
            return;
        }
        this.doRender(toRender, context);
    }

    private <T> void doRender(T toRender, Context context) throws Exception {
        Class type = (Class)Types.cast(toRender.getClass());
        T decorated = toRender;
        for (RenderableDecorator<?> decorator : context.getAll(RENDERABLE_DECORATOR_TYPE)) {
            if (!decorator.getType().isAssignableFrom(type)) continue;
            RenderableDecorator cast = (RenderableDecorator)Types.cast(decorator);
            decorated = cast.decorate(context, decorated);
        }
        Iterable<Renderer<?>> renderers = context.getAll(RENDERER_TYPE);
        for (Renderer<?> renderer : renderers) {
            if (!renderer.getType().isAssignableFrom(type)) continue;
            Renderer cast = (Renderer)Types.cast(renderer);
            try {
                cast.render(context, decorated);
                return;
            }
            catch (Exception e) {
                throw new RendererException(renderer, decorated, e);
            }
        }
        throw new NoSuchRendererException(decorated);
    }
}

