/*
 * Decompiled with CFR 0.152.
 */
package ratpack.server.internal;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.PooledByteBufAllocator;
import ratpack.error.ClientErrorHandler;
import ratpack.error.ServerErrorHandler;
import ratpack.error.internal.DefaultDevelopmentErrorHandler;
import ratpack.error.internal.DefaultProductionErrorHandler;
import ratpack.error.internal.ErrorHandler;
import ratpack.exec.ExecControl;
import ratpack.exec.ExecController;
import ratpack.exec.ExecInterceptor;
import ratpack.exec.internal.DefaultExecController;
import ratpack.file.FileSystemBinding;
import ratpack.file.MimeTypes;
import ratpack.file.internal.ActivationBackedMimeTypes;
import ratpack.file.internal.DefaultFileRenderer;
import ratpack.form.internal.FormNoOptParser;
import ratpack.form.internal.FormParser;
import ratpack.func.Function;
import ratpack.handling.Redirector;
import ratpack.handling.internal.DefaultRedirector;
import ratpack.health.internal.HealthCheckResultsRenderer;
import ratpack.http.client.HttpClient;
import ratpack.registry.Registries;
import ratpack.registry.Registry;
import ratpack.registry.RegistrySpec;
import ratpack.render.internal.CharSequenceRenderer;
import ratpack.render.internal.PromiseRenderer;
import ratpack.render.internal.PublisherRenderer;
import ratpack.render.internal.RenderableRenderer;
import ratpack.server.PublicAddress;
import ratpack.server.RatpackServer;
import ratpack.server.ServerConfig;
import ratpack.server.StartupFailureException;
import ratpack.server.Stopper;
import ratpack.server.internal.DefaultPublicAddress;
import ratpack.sse.ServerSentEventStreamClient;
import ratpack.util.Exceptions;

public abstract class ServerRegistry {
    public static Registry serverRegistry(RatpackServer ratpackServer, DefaultExecController execController, ServerConfig serverConfig, Function<? super Registry, ? extends Registry> userRegistryFactory) {
        Registry baseRegistry = ServerRegistry.buildBaseRegistry(ratpackServer, execController, serverConfig);
        Registry userRegistry = ServerRegistry.buildUserRegistry(userRegistryFactory, baseRegistry);
        ImmutableList interceptors = ImmutableList.copyOf(userRegistry.getAll(ExecInterceptor.class));
        execController.getControl().setDefaultInterceptors((ImmutableList<? extends ExecInterceptor>)interceptors);
        return baseRegistry.join(userRegistry);
    }

    private static Registry buildUserRegistry(Function<? super Registry, ? extends Registry> userRegistryFactory, Registry baseRegistry) {
        Registry userRegistry;
        try {
            userRegistry = userRegistryFactory.apply(baseRegistry);
        }
        catch (Exception e) {
            Throwables.propagateIfPossible((Throwable)e);
            throw new StartupFailureException("Failed to build user registry", e);
        }
        return userRegistry;
    }

    public static Registry buildBaseRegistry(RatpackServer ratpackServer, ExecController execController, ServerConfig serverConfig) {
        RegistrySpec baseRegistryBuilder;
        ErrorHandler errorHandler = serverConfig.isDevelopment() ? new DefaultDevelopmentErrorHandler() : new DefaultProductionErrorHandler();
        try {
            baseRegistryBuilder = Registries.registry().add(ServerConfig.class, (Object)serverConfig).add(ByteBufAllocator.class, PooledByteBufAllocator.DEFAULT).add(ExecController.class, execController).add(ExecControl.class, execController.getControl()).add(MimeTypes.class, new ActivationBackedMimeTypes()).add(PublicAddress.class, new DefaultPublicAddress(serverConfig.getPublicAddress(), serverConfig.getSSLContext() == null ? "http" : "https")).add(Redirector.class, new DefaultRedirector()).add(ClientErrorHandler.class, errorHandler).add(ServerErrorHandler.class, errorHandler).with(new DefaultFileRenderer().register()).with(new PromiseRenderer().register()).with(new PublisherRenderer().register()).with(new RenderableRenderer().register()).with(new CharSequenceRenderer().register()).add(FormParser.class, FormParser.multiPart()).add(FormParser.class, FormParser.urlEncoded()).add(FormNoOptParser.class, FormNoOptParser.multiPart()).add(FormNoOptParser.class, FormNoOptParser.urlEncoded()).add(RatpackServer.class, ratpackServer).add(Stopper.class, () -> Exceptions.uncheck(() -> {
                ratpackServer.stop();
                return null;
            })).add(HttpClient.class, HttpClient.httpClient(execController, (ByteBufAllocator)PooledByteBufAllocator.DEFAULT, serverConfig.getMaxContentLength())).add(ServerSentEventStreamClient.class, ServerSentEventStreamClient.sseStreamClient(execController, (ByteBufAllocator)PooledByteBufAllocator.DEFAULT)).add(HealthCheckResultsRenderer.class, new HealthCheckResultsRenderer());
        }
        catch (Exception e) {
            throw Exceptions.uncheck(e);
        }
        if (serverConfig.isHasBaseDir()) {
            baseRegistryBuilder.add(FileSystemBinding.class, serverConfig.getBaseDir());
        }
        return baseRegistryBuilder.build();
    }
}

