/*
 * Decompiled with CFR 0.152.
 */
package ratpack.config.internal;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.guava.GuavaModule;
import com.fasterxml.jackson.datatype.jdk7.Jdk7Module;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JSR310Module;
import com.google.common.collect.ImmutableList;
import com.google.common.io.ByteSource;
import com.google.common.io.Resources;
import java.net.URL;
import java.nio.file.Path;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import ratpack.config.ConfigData;
import ratpack.config.ConfigDataSpec;
import ratpack.config.ConfigSource;
import ratpack.config.EnvironmentParser;
import ratpack.config.internal.DefaultConfigData;
import ratpack.config.internal.module.ConfigModule;
import ratpack.config.internal.source.ByteSourcePropertiesConfigSource;
import ratpack.config.internal.source.EnvironmentConfigSource;
import ratpack.config.internal.source.ErrorHandlingConfigSource;
import ratpack.config.internal.source.JsonConfigSource;
import ratpack.config.internal.source.MapConfigSource;
import ratpack.config.internal.source.PropertiesConfigSource;
import ratpack.config.internal.source.YamlConfigSource;
import ratpack.func.Action;
import ratpack.func.Function;
import ratpack.server.internal.ServerEnvironment;
import ratpack.util.Exceptions;
import ratpack.util.internal.Paths2;

public class DefaultConfigDataSpec
implements ConfigDataSpec {
    private final ImmutableList.Builder<ConfigSource> sources = ImmutableList.builder();
    private final ServerEnvironment serverEnvironment;
    private final ObjectMapper objectMapper;
    private Action<? super Throwable> errorHandler = Action.throwException();

    public DefaultConfigDataSpec(ServerEnvironment serverEnvironment) {
        this(serverEnvironment, DefaultConfigDataSpec.newDefaultObjectMapper(serverEnvironment));
    }

    public DefaultConfigDataSpec(ServerEnvironment serverEnvironment, Module ... modules) {
        this(serverEnvironment, DefaultConfigDataSpec.newDefaultObjectMapper(serverEnvironment).registerModules(modules));
    }

    public DefaultConfigDataSpec(ServerEnvironment serverEnvironment, Optional<ObjectMapper> objectMapper) {
        this.serverEnvironment = serverEnvironment;
        this.objectMapper = objectMapper.orElse(DefaultConfigDataSpec.newDefaultObjectMapper(serverEnvironment));
    }

    public DefaultConfigDataSpec(ServerEnvironment serverEnvironment, ObjectMapper objectMapper) {
        this.serverEnvironment = serverEnvironment;
        this.objectMapper = objectMapper;
    }

    @Override
    public ConfigDataSpec add(ConfigSource configSource) {
        this.sources.add((Object)new ErrorHandlingConfigSource(configSource, this.errorHandler));
        return this;
    }

    @Override
    public ConfigData build() {
        return new DefaultConfigData(this);
    }

    @Override
    public ConfigDataSpec configureObjectMapper(Action<ObjectMapper> action) {
        try {
            action.execute(this.objectMapper);
        }
        catch (Exception ex) {
            throw Exceptions.uncheck(ex);
        }
        return this;
    }

    @Override
    public ConfigDataSpec env() {
        return this.add(new EnvironmentConfigSource(this.serverEnvironment));
    }

    @Override
    public ConfigDataSpec env(String prefix) {
        return this.add(new EnvironmentConfigSource(this.serverEnvironment, prefix));
    }

    @Override
    public ConfigDataSpec env(String prefix, Function<String, String> mapFunc) {
        return this.add(new EnvironmentConfigSource(this.serverEnvironment, prefix, mapFunc));
    }

    @Override
    public ConfigDataSpec env(EnvironmentParser environmentParser) {
        return this.add(new EnvironmentConfigSource(this.serverEnvironment, environmentParser));
    }

    @Override
    public ConfigDataSpec json(ByteSource byteSource) {
        return this.add(new JsonConfigSource(byteSource));
    }

    @Override
    public ConfigDataSpec json(Path path) {
        return this.add(new JsonConfigSource(path));
    }

    @Override
    public ConfigDataSpec json(URL url) {
        return this.add(new JsonConfigSource(url));
    }

    @Override
    public ConfigDataSpec props(ByteSource byteSource) {
        return this.add(new ByteSourcePropertiesConfigSource(Optional.empty(), byteSource));
    }

    @Override
    public ConfigDataSpec props(Path path) {
        return this.add(new ByteSourcePropertiesConfigSource(Optional.empty(), Paths2.asByteSource(path)));
    }

    @Override
    public ConfigDataSpec props(Properties properties) {
        return this.add(new PropertiesConfigSource(Optional.empty(), properties));
    }

    @Override
    public ConfigDataSpec props(URL url) {
        return this.add(new ByteSourcePropertiesConfigSource(Optional.empty(), Resources.asByteSource((URL)url)));
    }

    @Override
    public ConfigDataSpec props(Map<String, String> map) {
        return this.add(new MapConfigSource(Optional.empty(), map));
    }

    @Override
    public ConfigDataSpec sysProps() {
        return this.sysProps("ratpack.");
    }

    @Override
    public ConfigDataSpec sysProps(String prefix) {
        return this.add(new PropertiesConfigSource(Optional.of(prefix), this.serverEnvironment.getProperties()));
    }

    @Override
    public ConfigDataSpec yaml(ByteSource byteSource) {
        return this.add(new YamlConfigSource(byteSource));
    }

    @Override
    public ConfigDataSpec yaml(Path path) {
        return this.add(new YamlConfigSource(path));
    }

    @Override
    public ConfigDataSpec yaml(URL url) {
        return this.add(new YamlConfigSource(url));
    }

    @Override
    public ConfigDataSpec onError(Action<? super Throwable> errorHandler) {
        this.errorHandler = errorHandler;
        return this;
    }

    public static ObjectMapper newDefaultObjectMapper(ServerEnvironment serverEnvironment) {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        objectMapper.registerModule((Module)new Jdk7Module());
        objectMapper.registerModule((Module)new Jdk8Module());
        objectMapper.registerModule((Module)new GuavaModule());
        objectMapper.registerModule((Module)new JSR310Module());
        objectMapper.registerModule((Module)new ConfigModule(serverEnvironment));
        JsonFactory factory = objectMapper.getFactory();
        factory.enable(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES);
        factory.enable(JsonParser.Feature.ALLOW_SINGLE_QUOTES);
        return objectMapper;
    }

    @Override
    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    @Override
    public ImmutableList<ConfigSource> getConfigSources() {
        return this.sources.build();
    }
}

