/*
 * Decompiled with CFR 0.152.
 */
package ratpack.exec.internal;

import com.google.common.reflect.TypeToken;
import io.netty.channel.EventLoop;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;
import ratpack.exec.ExecBuilder;
import ratpack.exec.ExecControl;
import ratpack.exec.ExecController;
import ratpack.exec.ExecInterceptor;
import ratpack.exec.Execution;
import ratpack.exec.Fulfiller;
import ratpack.exec.Promise;
import ratpack.func.Action;
import ratpack.func.Block;
import ratpack.registry.internal.SimpleMutableRegistry;
import ratpack.stream.TransformablePublisher;

public class DefaultExecution
extends SimpleMutableRegistry
implements Execution {
    private final EventLoop eventLoop;
    private final ExecController controller;
    private final List<AutoCloseable> closeables;

    public DefaultExecution(EventLoop eventLoop, ExecController controller, List<AutoCloseable> closeables) {
        this.eventLoop = eventLoop;
        this.controller = controller;
        this.closeables = closeables;
    }

    @Override
    public ExecController getController() {
        return this.controller;
    }

    @Override
    public Execution getExecution() {
        return this.getControl().getExecution();
    }

    public static ExecControl current() {
        return ExecControl.current();
    }

    @Override
    public ExecControl getControl() {
        return this.controller.getControl();
    }

    @Override
    public EventLoop getEventLoop() {
        return this.eventLoop;
    }

    @Override
    public void onCleanup(AutoCloseable autoCloseable) {
        this.closeables.add(autoCloseable);
    }

    @Override
    public <O> Execution addLazy(TypeToken<O> type, Supplier<? extends O> supplier) {
        super.addLazy(type, supplier);
        return this;
    }

    @Override
    public <O> Execution add(TypeToken<? super O> type, O object) {
        super.add(type, object);
        return this;
    }

    @Override
    public <T> TransformablePublisher<T> stream(Publisher<T> publisher) {
        return this.getControl().stream(publisher);
    }

    @Override
    public ExecBuilder fork() {
        return this.getControl().fork();
    }

    @Override
    public <T> Promise<T> promiseOf(T item) {
        return this.getControl().promiseOf(item);
    }

    @Override
    public <T> Promise<T> promise(Action<? super Fulfiller<T>> action) {
        return this.getControl().promise(action);
    }

    @Override
    public <T> Promise<T> blocking(Callable<T> blockingOperation) {
        return this.getControl().blocking(blockingOperation);
    }

    @Override
    public void addInterceptor(ExecInterceptor execInterceptor, Block continuation) throws Exception {
        this.getControl().addInterceptor(execInterceptor, continuation);
    }
}

