/*
 * Decompiled with CFR 0.152.
 */
package ratpack.file;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.concurrent.ExecutionException;
import ratpack.file.FileSystemChecksumService;
import ratpack.util.Exceptions;

public class CachingFileSystemChecksumService
implements FileSystemChecksumService {
    private final FileSystemChecksumService delegate;
    private final LoadingCache<String, Entry> cache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, Entry>(){

        public Entry load(String key) throws Exception {
            return new Entry(CachingFileSystemChecksumService.this.delegate.checksum(key));
        }
    });

    public CachingFileSystemChecksumService(FileSystemChecksumService delegate) {
        this.delegate = delegate;
    }

    @Override
    public String checksum(String path) throws Exception {
        if (path == null) {
            return null;
        }
        try {
            return ((Entry)this.cache.get((Object)path)).checksum;
        }
        catch (UncheckedExecutionException | ExecutionException e) {
            throw Exceptions.toException(e.getCause());
        }
    }

    private static class Entry {
        private final String checksum;

        private Entry(String checksum) {
            this.checksum = checksum;
        }
    }
}

