/*
 * Decompiled with CFR 0.152.
 */
package ratpack.file.internal;

import com.google.common.collect.ImmutableList;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import ratpack.file.internal.DefaultFileRenderer;
import ratpack.handling.Context;
import ratpack.handling.Handler;
import ratpack.http.Request;
import ratpack.path.PathBinding;
import ratpack.util.Exceptions;

public class AssetHandler
implements Handler {
    private final ImmutableList<String> indexFiles;

    public AssetHandler(ImmutableList<String> indexFiles) {
        this.indexFiles = indexFiles;
    }

    @Override
    public void handle(Context context) throws Exception {
        Request request = context.getRequest();
        String path = context.maybeGet(PathBinding.class).map(PathBinding::getPastBinding).orElse(request.getPath());
        try {
            path = new URI(path).getPath();
        }
        catch (URISyntaxException e) {
            throw Exceptions.uncheck(e);
        }
        Path asset = context.file(path);
        if (asset != null) {
            this.servePath(context, asset);
        } else {
            context.clientError(404);
        }
    }

    private void servePath(Context context, Path file) throws Exception {
        DefaultFileRenderer.readAttributes(context, file, attributes -> {
            if (attributes == null) {
                context.next();
            } else if (attributes.isRegularFile()) {
                DefaultFileRenderer.sendFile(context, file, attributes);
            } else if (attributes.isDirectory()) {
                this.maybeSendFile(context, file, 0);
            } else {
                context.next();
            }
        });
    }

    private void maybeSendFile(Context context, Path file, int i) throws Exception {
        if (i == this.indexFiles.size()) {
            context.next();
        } else {
            String name = (String)this.indexFiles.get(i);
            Path indexFile = file.resolve(name);
            DefaultFileRenderer.readAttributes(context, indexFile, attributes -> {
                if (attributes != null && attributes.isRegularFile()) {
                    String path3 = context.getRequest().getPath();
                    if (path3.endsWith("/") || path3.isEmpty()) {
                        DefaultFileRenderer.sendFile(context, indexFile, attributes);
                    } else {
                        context.redirect(this.currentUriWithTrailingSlash(context));
                    }
                } else {
                    this.maybeSendFile(context, file, i + 1);
                }
            });
        }
    }

    private String currentUriWithTrailingSlash(Context context) {
        Request request = context.getRequest();
        String redirectUri = "/" + request.getPath() + "/";
        String query = request.getQuery();
        if (!query.isEmpty()) {
            redirectUri = redirectUri + "?" + query;
        }
        return redirectUri;
    }
}

