/*
 * Decompiled with CFR 0.152.
 */
package ratpack.func;

import java.util.function.Consumer;
import ratpack.func.Block;
import ratpack.util.Exceptions;

@FunctionalInterface
public interface Action<T> {
    public void execute(T var1) throws Exception;

    public static Action<Object> noop() {
        return thing -> {};
    }

    public static <T> Action<? super T> noopIfNull(Action<T> action) {
        if (action == null) {
            return Action.noop();
        }
        return action;
    }

    @SafeVarargs
    public static <T> Action<T> join(final Action<? super T> ... actions) {
        return new Action<T>(){

            @Override
            public void execute(T thing) throws Exception {
                for (Action action : actions) {
                    action.execute(thing);
                }
            }
        };
    }

    public static Action<Throwable> throwException() {
        return throwable -> {
            throw Exceptions.toException(throwable);
        };
    }

    public static <T> Action<T> throwException(Throwable throwable) {
        return t -> {
            throw Exceptions.toException(throwable);
        };
    }

    public static <T> Action<T> ignoreArg(Block block) {
        return t -> block.execute();
    }

    public static <T> T with(T t, Action<? super T> action) throws Exception {
        return action.with(t);
    }

    default public <O extends T> O with(O o) throws Exception {
        this.execute(o);
        return o;
    }

    public static <T> T uncheckedWith(T t, Action<? super T> action) {
        return action.uncheckedWith(t);
    }

    default public <O extends T> O uncheckedWith(O o) {
        return (O)Exceptions.uncheck(() -> {
            this.execute(o);
            return o;
        });
    }

    default public Consumer<T> toConsumer() {
        return t -> {
            try {
                this.execute(t);
            }
            catch (Exception e) {
                throw Exceptions.uncheck(e);
            }
        };
    }

    public static <T> Action<T> from(Consumer<T> consumer) {
        return consumer::accept;
    }
}

