/*
 * Decompiled with CFR 0.152.
 */
package ratpack.handling.internal;

import com.google.common.collect.ImmutableList;
import java.util.List;
import ratpack.func.Action;
import ratpack.handling.Chain;
import ratpack.handling.Handler;
import ratpack.handling.Handlers;
import ratpack.registry.Registries;
import ratpack.registry.Registry;
import ratpack.registry.RegistrySpec;
import ratpack.server.ServerConfig;

public class DefaultChain
implements Chain {
    private final List<Handler> handlers;
    private final ServerConfig serverConfig;
    private final Registry registry;

    public DefaultChain(List<Handler> handlers, ServerConfig serverConfig, Registry registry) {
        this.handlers = handlers;
        this.serverConfig = serverConfig;
        this.registry = registry;
    }

    @Override
    public Chain assets(String path, String ... indexFiles) {
        return this.handler(Handlers.assets(this.getServerConfig(), path, (List<String>)ImmutableList.copyOf((Object[])indexFiles)));
    }

    @Override
    public Handler chain(Action<? super Chain> action) throws Exception {
        return Handlers.chain(this.getServerConfig(), this.getRegistry(), action);
    }

    @Override
    public Chain delete(String path, Handler handler) {
        return this.handler(Handlers.path(path, Handlers.chain(Handlers.delete(), handler)));
    }

    @Override
    public Chain delete(Handler handler) {
        return this.delete("", handler);
    }

    @Override
    public Chain fileSystem(String path, Action<? super Chain> action) throws Exception {
        return this.handler(Handlers.fileSystem(this.getServerConfig(), path, this.chain(action)));
    }

    @Override
    public Chain get(String path, Handler handler) {
        return this.handler(Handlers.path(path, Handlers.chain(Handlers.get(), handler)));
    }

    @Override
    public Chain get(Handler handler) {
        return this.get("", handler);
    }

    @Override
    public ServerConfig getServerConfig() {
        return this.serverConfig;
    }

    @Override
    public Registry getRegistry() {
        return this.registry;
    }

    @Override
    public Chain handler(Handler handler) {
        this.handlers.add(handler);
        return this;
    }

    @Override
    public Chain handler(String path, Handler handler) {
        return this.handler(Handlers.path(path, handler));
    }

    @Override
    public Chain header(String headerName, String headerValue, Handler handler) {
        return this.handler(Handlers.header(headerName, headerValue, handler));
    }

    @Override
    public Chain host(String hostName, Action<? super Chain> action) throws Exception {
        return this.handler(Handlers.host(hostName, this.chain(action)));
    }

    @Override
    public Chain patch(String path, Handler handler) {
        return this.handler(Handlers.path(path, Handlers.chain(Handlers.patch(), handler)));
    }

    @Override
    public Chain patch(Handler handler) {
        return this.patch("", handler);
    }

    @Override
    public Chain post(String path, Handler handler) {
        return this.handler(Handlers.path(path, Handlers.chain(Handlers.post(), handler)));
    }

    @Override
    public Chain post(Handler handler) {
        return this.post("", handler);
    }

    @Override
    public Chain prefix(String prefix, Action<? super Chain> action) throws Exception {
        return this.handler(Handlers.prefix(prefix, this.chain(action)));
    }

    @Override
    public Chain put(String path, Handler handler) {
        return this.handler(Handlers.path(path, Handlers.chain(Handlers.put(), handler)));
    }

    @Override
    public Chain put(Handler handler) {
        return this.put("", handler);
    }

    @Override
    public Chain register(Registry registry) {
        return this.handler(Handlers.register(registry));
    }

    @Override
    public Chain register(Action<? super RegistrySpec> action) throws Exception {
        return this.handler(Handlers.register(Registries.registry(action)));
    }

    @Override
    public Chain register(Action<? super RegistrySpec> registryAction, Action<? super Chain> chainAction) throws Exception {
        return this.register(Registries.registry(registryAction), chainAction);
    }

    @Override
    public Chain register(Registry registry, Action<? super Chain> action) throws Exception {
        return this.handler(Handlers.register(registry, this.chain(action)));
    }

    @Override
    public Chain insert(Action<? super Chain> action) throws Exception {
        return this.handler(this.chain(action));
    }

    @Override
    public Chain redirect(int code, String location) {
        return this.handler(Handlers.redirect(code, location));
    }
}

