/*
 * Decompiled with CFR 0.152.
 */
package ratpack.http.client.internal;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.PrematureChannelClosureException;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.timeout.ReadTimeoutHandler;
import java.net.URI;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import ratpack.exec.Execution;
import ratpack.exec.Fulfiller;
import ratpack.func.Action;
import ratpack.http.MutableHeaders;
import ratpack.http.Status;
import ratpack.http.client.RequestSpec;
import ratpack.http.client.internal.RequestAction;
import ratpack.http.client.internal.RequestParams;
import ratpack.http.client.internal.RequestSpecBacking;
import ratpack.http.internal.DefaultStatus;
import ratpack.http.internal.HttpHeaderConstants;
import ratpack.http.internal.NettyHeadersBackedHeaders;
import ratpack.http.internal.NettyHeadersBackedMutableHeaders;
import ratpack.util.Exceptions;
import ratpack.util.internal.ChannelImplDetector;

abstract class RequestActionSupport<T>
implements RequestAction<T> {
    private static final Pattern ABSOLUTE_PATTERN = Pattern.compile("^https?://.*");
    private final Action<? super RequestSpec> requestConfigurer;
    private final boolean finalUseSsl;
    private final String host;
    private final int port;
    private final MutableHeaders headers;
    private final RequestSpecBacking requestSpecBacking;
    private final URI uri;
    private final RequestParams requestParams;
    private final AtomicBoolean fired = new AtomicBoolean();
    protected final Execution execution;
    protected final ByteBufAllocator byteBufAllocator;

    public RequestActionSupport(Action<? super RequestSpec> requestConfigurer, URI uri, Execution execution, ByteBufAllocator byteBufAllocator) {
        this.execution = execution;
        this.requestConfigurer = requestConfigurer;
        this.byteBufAllocator = byteBufAllocator;
        this.uri = uri;
        this.requestParams = new RequestParams();
        this.headers = new NettyHeadersBackedMutableHeaders((HttpHeaders)new DefaultHttpHeaders());
        this.requestSpecBacking = new RequestSpecBacking(this.headers, uri, byteBufAllocator, this.requestParams);
        try {
            requestConfigurer.execute(this.requestSpecBacking.asSpec());
        }
        catch (Exception e) {
            throw Exceptions.uncheck(e);
        }
        String scheme = uri.getScheme();
        boolean useSsl = false;
        if (scheme.equals("https")) {
            useSsl = true;
        } else if (!scheme.equals("http")) {
            throw new IllegalArgumentException(String.format("URL '%s' is not a http url", uri.toString()));
        }
        this.finalUseSsl = useSsl;
        this.host = uri.getHost();
        this.port = uri.getPort() < 0 ? (useSsl ? 443 : 80) : uri.getPort();
    }

    @Override
    public void execute(final Fulfiller<? super T> fulfiller) throws Exception {
        final AtomicBoolean redirecting = new AtomicBoolean();
        Bootstrap b = new Bootstrap();
        ((Bootstrap)((Bootstrap)b.group((EventLoopGroup)this.execution.getEventLoop())).channel(ChannelImplDetector.getSocketChannelImpl())).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) throws Exception {
                final ChannelPipeline p = ch.pipeline();
                if (RequestActionSupport.this.finalUseSsl) {
                    SSLEngine engine = SSLContext.getDefault().createSSLEngine();
                    engine.setUseClientMode(true);
                    p.addLast("ssl", (ChannelHandler)new SslHandler(engine));
                }
                p.addLast("codec", (ChannelHandler)new HttpClientCodec());
                p.addLast("readTimeout", (ChannelHandler)new ReadTimeoutHandler(((RequestActionSupport)RequestActionSupport.this).requestParams.readTimeoutNanos, TimeUnit.NANOSECONDS));
                p.addLast("redirectHandler", (ChannelHandler)new SimpleChannelInboundHandler<HttpObject>(false){
                    boolean readComplete;

                    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
                        if (!this.readComplete) {
                            RequestActionSupport.this.error(fulfiller, (Throwable)new PrematureChannelClosureException("Server " + RequestActionSupport.this.uri + " closed the connection prematurely"));
                        }
                        super.channelReadComplete(ctx);
                    }

                    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
                        super.exceptionCaught(ctx, cause);
                    }

                    protected void channelRead0(ChannelHandlerContext ctx, HttpObject msg) throws Exception {
                        if (msg instanceof HttpResponse) {
                            this.readComplete = true;
                            HttpResponse response = (HttpResponse)msg;
                            NettyHeadersBackedHeaders headers = new NettyHeadersBackedHeaders(response.headers());
                            DefaultStatus status = new DefaultStatus(response.status());
                            int maxRedirects = RequestActionSupport.this.requestSpecBacking.getMaxRedirects();
                            String locationValue = headers.get("Location");
                            if (RequestActionSupport.shouldRedirect(status) && maxRedirects > 0 && locationValue != null) {
                                redirecting.compareAndSet(false, true);
                                Action redirectRequestConfig = Action.join(RequestActionSupport.this.requestConfigurer, s -> {
                                    if (status.getCode() == 301 || status.getCode() == 302) {
                                        s.method("GET");
                                    }
                                    s.redirects(maxRedirects - 1);
                                });
                                URI locationUrl = ABSOLUTE_PATTERN.matcher(locationValue).matches() ? new URI(locationValue) : new URI(RequestActionSupport.this.uri.getScheme(), null, RequestActionSupport.this.uri.getHost(), RequestActionSupport.this.uri.getPort(), locationValue, null, null);
                                RequestActionSupport.this.buildRedirectRequestAction(redirectRequestConfig, locationUrl).execute(fulfiller);
                            } else {
                                p.remove((ChannelHandler)this);
                            }
                        }
                        if (!redirecting.get()) {
                            ctx.fireChannelRead((Object)msg);
                        }
                    }
                });
                RequestActionSupport.this.addResponseHandlers(p, fulfiller);
            }

            public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
                ctx.close();
                RequestActionSupport.this.error(fulfiller, cause);
            }
        });
        ChannelFuture connectFuture = b.connect(this.host, this.port);
        connectFuture.addListener(f1 -> {
            if (connectFuture.isSuccess()) {
                String fullPath = RequestActionSupport.getFullPath(this.uri);
                DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.valueOf((String)this.requestSpecBacking.getMethod()), fullPath, this.requestSpecBacking.getBody());
                if (this.headers.get(HttpHeaderConstants.HOST) == null) {
                    this.headers.set(HttpHeaderConstants.HOST, this.host);
                }
                this.headers.set(HttpHeaderConstants.CONNECTION, HttpHeaderValues.CLOSE);
                int contentLength = request.content().readableBytes();
                if (contentLength > 0) {
                    this.headers.set(HttpHeaderConstants.CONTENT_LENGTH, Integer.toString(contentLength, 10));
                }
                HttpHeaders requestHeaders = request.headers();
                for (String name : this.headers.getNames()) {
                    requestHeaders.set(name, this.headers.getAll(name));
                }
                ChannelFuture writeFuture = connectFuture.channel().writeAndFlush((Object)request);
                writeFuture.addListener(f2 -> {
                    if (!writeFuture.isSuccess()) {
                        writeFuture.channel().close();
                        this.error(fulfiller, writeFuture.cause());
                    }
                });
            } else {
                connectFuture.channel().close();
                this.error(fulfiller, connectFuture.cause());
            }
        });
    }

    protected abstract RequestAction<T> buildRedirectRequestAction(Action<? super RequestSpec> var1, URI var2);

    protected abstract void addResponseHandlers(ChannelPipeline var1, Fulfiller<? super T> var2);

    protected void success(Fulfiller<? super T> fulfiller, T value) {
        if (this.fired.compareAndSet(false, true)) {
            fulfiller.success(value);
        }
    }

    protected void error(Fulfiller<?> fulfiller, Throwable error) {
        if (this.fired.compareAndSet(false, true)) {
            fulfiller.error(error);
        }
    }

    private static boolean shouldRedirect(Status status) {
        int code = status.getCode();
        return code == 301 || code == 302 || code == 303 || code == 307;
    }

    private static String getFullPath(URI uri) {
        StringBuilder sb = new StringBuilder(uri.getRawPath());
        String query = uri.getRawQuery();
        if (query != null) {
            sb.append("?").append(query);
        }
        return sb.toString();
    }
}

