/*
 * Decompiled with CFR 0.152.
 */
package ratpack.server.internal;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.DefaultFileRegion;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpChunkedInput;
import io.netty.handler.codec.http.HttpHeaderUtil;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.stream.ChunkedInput;
import io.netty.handler.stream.ChunkedNioStream;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.FileInputStream;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.concurrent.atomic.AtomicBoolean;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ratpack.event.internal.DefaultEventController;
import ratpack.exec.ExecControl;
import ratpack.file.internal.ResponseTransmitter;
import ratpack.handling.DoubleTransmissionException;
import ratpack.handling.RequestOutcome;
import ratpack.handling.internal.DefaultRequestOutcome;
import ratpack.http.Request;
import ratpack.http.internal.CustomHttpResponse;
import ratpack.http.internal.DefaultSentResponse;
import ratpack.http.internal.DefaultStatus;
import ratpack.http.internal.HttpHeaderConstants;
import ratpack.http.internal.NettyHeadersBackedHeaders;

public class DefaultResponseTransmitter
implements ResponseTransmitter {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultResponseTransmitter.class);
    private static final Runnable NOOP_RUNNABLE = () -> {};
    private final AtomicBoolean transmitted;
    private final ExecControl execControl;
    private final Channel channel;
    private final FullHttpRequest nettyRequest;
    private final Request ratpackRequest;
    private final HttpHeaders responseHeaders;
    private final DefaultEventController<RequestOutcome> requestOutcomeEventController;
    private final boolean isKeepAlive;
    private final boolean isSsl;
    private long stopTime;
    private Runnable onWritabilityChanged = NOOP_RUNNABLE;

    public DefaultResponseTransmitter(AtomicBoolean transmitted, ExecControl execControl, Channel channel, FullHttpRequest nettyRequest, Request ratpackRequest, HttpHeaders responseHeaders, DefaultEventController<RequestOutcome> requestOutcomeEventController) {
        this.transmitted = transmitted;
        this.execControl = execControl;
        this.channel = channel;
        this.nettyRequest = nettyRequest.retain();
        this.ratpackRequest = ratpackRequest;
        this.responseHeaders = responseHeaders;
        this.requestOutcomeEventController = requestOutcomeEventController;
        this.isKeepAlive = HttpHeaderUtil.isKeepAlive((HttpMessage)nettyRequest);
        this.isSsl = channel.pipeline().get(SslHandler.class) != null;
    }

    private ChannelFuture pre(HttpResponseStatus responseStatus) {
        if (this.transmitted.compareAndSet(false, true)) {
            this.stopTime = System.nanoTime();
            CustomHttpResponse headersResponse = new CustomHttpResponse(responseStatus, this.responseHeaders);
            this.nettyRequest.release();
            if (this.isKeepAlive) {
                headersResponse.headers().set(HttpHeaderConstants.CONNECTION, (Object)HttpHeaderConstants.KEEP_ALIVE);
            }
            if (this.channel.isOpen()) {
                return this.channel.writeAndFlush((Object)headersResponse).addListener((GenericFutureListener)ChannelFutureListener.CLOSE_ON_FAILURE);
            }
            return null;
        }
        String msg = "attempt at double transmission for: " + this.ratpackRequest.getRawUri();
        LOGGER.warn(msg, (Throwable)new DoubleTransmissionException(msg));
        return null;
    }

    @Override
    public void transmit(HttpResponseStatus responseStatus, ByteBuf body) {
        this.transmit(responseStatus, new DefaultHttpContent(body));
    }

    private void transmit(HttpResponseStatus responseStatus, Object body) {
        ChannelFuture channelFuture = this.pre(responseStatus);
        if (channelFuture == null) {
            return;
        }
        channelFuture.addListener(future -> {
            if (this.channel.isOpen()) {
                this.channel.write(body);
                this.post(responseStatus);
            }
        });
    }

    @Override
    public void transmit(HttpResponseStatus status, Path file) {
        String sizeString = this.responseHeaders.get(HttpHeaderConstants.CONTENT_LENGTH);
        long size = sizeString == null ? 0L : Long.parseLong(sizeString);
        boolean compress = !this.responseHeaders.contains(HttpHeaderConstants.CONTENT_ENCODING, HttpHeaderConstants.IDENTITY, true);
        this.responseHeaders.set(HttpHeaderConstants.CONTENT_LENGTH, (Object)size);
        if (!this.isSsl && !compress && file.getFileSystem().equals(FileSystems.getDefault())) {
            this.execControl.blocking(() -> new FileInputStream(file.toFile()).getChannel()).then(fileChannel -> {
                DefaultFileRegion defaultFileRegion = new DefaultFileRegion(fileChannel, 0L, size);
                this.transmit(status, defaultFileRegion);
            });
        } else {
            this.execControl.blocking(() -> Files.newByteChannel(file, new OpenOption[0])).then(fileChannel -> this.transmit(status, new HttpChunkedInput((ChunkedInput)new ChunkedNioStream((ReadableByteChannel)fileChannel))));
        }
    }

    @Override
    public Subscriber<ByteBuf> transmitter(final HttpResponseStatus responseStatus) {
        return new Subscriber<ByteBuf>(){
            private Subscription subscription;
            private final AtomicBoolean done = new AtomicBoolean();
            private final ChannelFutureListener cancelOnFailure = future -> {
                if (!this.done.get() && !future.isSuccess()) {
                    this.cancel();
                }
            };

            private void cancel() {
                if (this.done.compareAndSet(false, true)) {
                    this.subscription.cancel();
                    DefaultResponseTransmitter.this.post(responseStatus);
                }
            }

            public void onSubscribe(Subscription subscription) {
                if (subscription == null) {
                    throw new NullPointerException("'subscription' is null");
                }
                if (this.subscription != null) {
                    subscription.cancel();
                    return;
                }
                this.subscription = subscription;
                DefaultResponseTransmitter.this.onWritabilityChanged = () -> {
                    if (DefaultResponseTransmitter.this.channel.isWritable() && !this.done.get()) {
                        this.subscription.request(1L);
                    }
                };
                ChannelFuture channelFuture = DefaultResponseTransmitter.this.pre(responseStatus);
                if (channelFuture == null) {
                    subscription.cancel();
                    DefaultResponseTransmitter.this.notifyListeners(responseStatus, DefaultResponseTransmitter.this.channel.close());
                } else {
                    channelFuture.addListener((GenericFutureListener)this.cancelOnFailure);
                    if (DefaultResponseTransmitter.this.channel.isWritable()) {
                        this.subscription.request(1L);
                    }
                }
            }

            public void onNext(ByteBuf o) {
                if (DefaultResponseTransmitter.this.channel.isOpen()) {
                    DefaultResponseTransmitter.this.channel.writeAndFlush((Object)new DefaultHttpContent(o)).addListener((GenericFutureListener)this.cancelOnFailure);
                    if (DefaultResponseTransmitter.this.channel.isWritable()) {
                        this.subscription.request(1L);
                    }
                } else {
                    this.cancel();
                }
            }

            public void onError(Throwable t) {
                if (t == null) {
                    throw new NullPointerException("error is null");
                }
                LOGGER.warn("Exception thrown transmitting stream", t);
                if (this.done.compareAndSet(false, true)) {
                    DefaultResponseTransmitter.this.post(responseStatus);
                }
            }

            public void onComplete() {
                if (this.done.compareAndSet(false, true)) {
                    DefaultResponseTransmitter.this.post(responseStatus);
                }
            }
        };
    }

    private void post(HttpResponseStatus responseStatus) {
        if (this.channel.isOpen()) {
            ChannelFuture lastContentFuture = this.channel.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT);
            if (!this.isKeepAlive) {
                lastContentFuture.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            }
            this.notifyListeners(responseStatus, lastContentFuture);
        } else {
            this.notifyListeners(responseStatus, this.channel.newSucceededFuture());
        }
    }

    private void notifyListeners(HttpResponseStatus responseStatus, ChannelFuture future) {
        if (this.requestOutcomeEventController.isHasListeners()) {
            future.addListener(ignore -> {
                DefaultSentResponse sentResponse = new DefaultSentResponse(new NettyHeadersBackedHeaders(this.responseHeaders), new DefaultStatus(responseStatus));
                DefaultRequestOutcome requestOutcome = new DefaultRequestOutcome(this.ratpackRequest, sentResponse, this.stopTime);
                this.requestOutcomeEventController.fire(requestOutcome);
            });
        }
    }

    public void writabilityChanged() {
        this.onWritabilityChanged.run();
    }
}

